﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

using Livet;

using Azyobuzi.HatenaDiaryClient.Models.Hatena;

namespace Azyobuzi.HatenaDiaryClient.Models
{
    internal class Model : NotifyObject
    {
        /*
         * NotifyObjectはプロパティ変更通知の仕組みを実装したオブジェクトです。
         */

        internal Model()
        {
            this.Tabs = new DispatcherCollection<Tab>(DispatcherHelper.UIDispatcher);
            this.AddTab(null);
        }

        private Settings settings;
        public Settings Settings
        {
            set
            {
                if (this.settings != null)
                    this.settings.PropertyChanged -= this.Settings_PropertyChanged;
                this.settings = value;
                this.settings.PropertyChanged += this.Settings_PropertyChanged;
                this.Settings_PropertyChanged(this.settings, new PropertyChangedEventArgs("HatenaId"));//キモい
                this.RaisePropertyChanged("Settings");
            }
            get
            {
                if (this.settings == null)
                    this.Settings = Settings.Load();
                return this.settings;
            }
        }

        private void Settings_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            switch (e.PropertyName)
            {
                case "HatenaId":
                case "Password":
                    diary.UserName = this.Settings.HatenaId;
                    diary.Password = this.Settings.Password;
                    fotolife.UserName = this.Settings.HatenaId;
                    fotolife.Password = this.Settings.Password;
                    break;
            }
        }

        /// <summary>
        /// ID・パスワードが設定済みか
        /// </summary>
        public bool SetIdPassword
        {
            get
            {
                return !string.IsNullOrEmpty(this.Settings.HatenaId) &&
                    !string.IsNullOrEmpty(this.Settings.Password);
            }
        }

        private HatenaDiary diary = new HatenaDiary();
        private HatenaFotolife fotolife = new HatenaFotolife();

        public DispatcherCollection<Tab> Tabs { private set; get; }

        public void Post(Tab tab)
        {
            var re = diary.PostEntry(tab.Editing.Title, tab.Editing.Content);
            tab.Editing.Entry = re;
            tab.TitleText = re.Title;
            tab.Modified = false;
        }

        public Tab AddTab(BlogItem entry)
        {
            string tabText;
            if (entry == null)
            {
                entry = new BlogItem();
                tabText = "新規";
            }
            else
            {
                tabText = entry.Draft != null ?
                    entry.Draft.Title : entry.Entry.Title;
            }
            var tab = new Tab()
            {
                Editing = entry,
                TitleText = tabText
            };
            this.Tabs.Add(tab);
            return tab;
        }
    }
}
