﻿using System;
using System.IO;
using System.Reflection;
using System.Text;
using System.Xml.Serialization;
using Livet;

namespace Azyobuzi.HatenaDiaryClient.Models
{
    public class Settings : NotifyObject
    {
        private static readonly string settingsFile =
            Path.GetDirectoryName(Environment.GetCommandLineArgs()[0]) + @"\settings.xml";

        private Settings() { }

        string _HatenaId;

        public string HatenaId
        {
            get
            { return _HatenaId; }
            set
            {
                if (_HatenaId == value)
                    return;
                _HatenaId = value;
                RaisePropertyChanged("HatenaId");
            }
        }
        
        string _Password;

        public string Password
        {
            get
            { return _Password; }
            set
            {
                if (_Password == value)
                    return;
                _Password = value;
                RaisePropertyChanged("Password");
            }
        }
                
        public static Settings Load()
        {
            try
            {
                using (var sr = new StreamReader(settingsFile))
                {
                    var xs = new XmlSerializer(typeof(Settings));
                    return (Settings)xs.Deserialize(sr);
                }
            }
            catch
            {
                return new Settings();
            }
        }

        public void Save()
        {
            using (var sw = new StreamWriter(settingsFile))
            {
                var xs = new XmlSerializer(typeof(Settings));
                xs.Serialize(sw, this);
            }
        }
    }
}
