﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Reflection;

using Livet;
using Livet.Command;
using Livet.Messaging;
using Livet.Messaging.File;
using Livet.Messaging.Window;

using Azyobuzi.HatenaDiaryClient.Models;

namespace Azyobuzi.HatenaDiaryClient.ViewModels
{
    class MainWindowViewModel : ViewModel
    {
        /*コマンド、プロパティの定義にはそれぞれ 
         * 
         *  ldcom   : DelegateCommand(パラメータ無)
         *  ldcomp  : DelegateCommand(型パラメータ有)
         *  lprop   : 変更通知プロパティ
         *  
         * を使用してください。
         */

        /*ViewModelからViewを操作したい場合は、
         * Messengerプロパティからメッセージ(各種InteractionMessage)を発信してください。
         */

        /*
         * UIDispatcherを操作する場合は、DispatcherHelperのメソッドを操作してください。
         * UIDispatcher自体はApp.xaml.csでインスタンスを確保してあります。
         */

        /*
         * Modelからの変更通知などの各種イベントをそのままViewModelで購読する事はメモリリークの
         * 原因となりやすく推奨できません。ViewModelHelperの各静的メソッドの利用を検討してください。
         */

        public MainWindowViewModel()
        {
            ViewModelHelper.BindNotifyChanged(this.model, this, (sender, e) =>
            {
                if (this.GetType().GetMember(e.PropertyName, BindingFlags.Instance | BindingFlags.GetProperty) != null)
                {
                    this.RaisePropertyChanged(e.PropertyName);
                }
            });
        }

        Model model = new Model();

        public Settings Settings
        {
            set
            {
                model.Settings = value;
            }
            get
            {
                return model.Settings;
            }
        }

        public DispatcherCollection<Tab> Tabs
        {
            get
            {
                return this.model.Tabs;
            }
        }

        
        Tab _SelectedTab;

        public Tab SelectedTab
        {
            get
            { return _SelectedTab; }
            set
            {
                if (_SelectedTab == value)
                    return;
                _SelectedTab = value;
                RaisePropertyChanged("SelectedTab");
            }
        }
      

        
        #region PostCommand
        DelegateCommand _PostCommand;

        public DelegateCommand PostCommand
        {
            get
            {
                if (_PostCommand == null)
                    _PostCommand = new DelegateCommand(Post, CanPost);
                return _PostCommand;
            }
        }

        private bool CanPost()
        {
            return this.model.SetIdPassword &&
                this.SelectedTab != null &&
                !string.IsNullOrEmpty(this.SelectedTab.Editing.Content);
        }

        private void Post()
        {
            this.model.Post(this.SelectedTab);
        }
        #endregion
        
        #region ShowSettingsWindowCommand
        DelegateCommand _ShowSettingsWindowCommand;

        public DelegateCommand ShowSettingsWindowCommand
        {
            get
            {
                if (_ShowSettingsWindowCommand == null)
                    _ShowSettingsWindowCommand = new DelegateCommand(ShowSettingsWindow);
                return _ShowSettingsWindowCommand;
            }
        }

        private void ShowSettingsWindow()
        {
            this.Messenger.Raise(new TransitionMessage(
                new SettingsWindowViewModel(this.Settings),
                "ShowSettingsWindow"));
        }
        #endregion
      
    }
}
