﻿using Azyobuzi.HatenaDiaryClient.Models;
using Livet;
using Livet.Command;
using Livet.Messaging;
using Livet.Messaging.Window;

namespace Azyobuzi.HatenaDiaryClient.ViewModels
{
    class SettingsWindowViewModel : ViewModel
    {
        public SettingsWindowViewModel(Settings settings)
        {
            this.Settings = settings;
        }

        private Settings settings;

        public Settings Settings
        {
            get { return settings; }
            set
            {
                settings = value;

                #region 設定読み取り
                this.HatenaId = this.settings.HatenaId;
                this.Password = this.settings.Password;
                #endregion
            }
        }
        

        #region 設定項目
        public string HatenaId { set; get; }
        public string Password { set; get; }
        #endregion

        #region SaveCommand
        DelegateCommand _SaveCommand;

        public DelegateCommand SaveCommand
        {
            get
            {
                if (_SaveCommand == null)
                    _SaveCommand = new DelegateCommand(Save);
                return _SaveCommand;
            }
        }

        private void Save()
        {
            this.Messenger.Raise(new InteractionMessage("ReqSetValues"));

            #region 設定適用
            this.Settings.HatenaId = this.HatenaId;
            this.Settings.Password = this.Password;
            #endregion

            this.Settings.Save();
            this.Cancel();
        }
        #endregion
        
        #region CancelCommand
        DelegateCommand _CancelCommand;

        public DelegateCommand CancelCommand
        {
            get
            {
                if (_CancelCommand == null)
                    _CancelCommand = new DelegateCommand(Cancel);
                return _CancelCommand;
            }
        }

        private void Cancel()
        {
            this.Messenger.Raise(new WindowActionMessage("Close", WindowAction.Close));
        }
        #endregion
      
    }
}
