/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.appengine.DatastoreExceptionTranslator;
import org.datanucleus.store.appengine.DatastoreFieldManager;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.DatastoreTransaction;
import org.datanucleus.store.appengine.DependentDeleteRequest;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.FetchMappingConsumer;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.util.NucleusLogger;

public class DatastorePersistenceHandler
implements StorePersistenceHandler {
    static final Object ENTITY_WRITE_DELAYED = "___entity_write_delayed___";
    private final DatastoreService datastoreService = DatastoreServiceFactoryInternal.getDatastoreService();
    private final DatastoreManager storeMgr;
    private static final Object INSERTION_TOKEN = new Object();

    public DatastorePersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (DatastoreManager)storeMgr;
    }

    Entity get(DatastoreTransaction txn, Key key) {
        NucleusLogger.DATASTORE.debug((Object)("Getting entity of kind " + key.getKind() + " with key " + key));
        try {
            Entity entity = txn == null ? this.datastoreService.get(key) : this.datastoreService.get(txn.getInnerTxn(), key);
            return entity;
        }
        catch (EntityNotFoundException e) {
            throw DatastoreExceptionTranslator.wrapEntityNotFoundException(e, key);
        }
    }

    private Entity get(StateManager sm, Key key) {
        DatastoreTransaction txn = EntityUtils.getCurrentTransaction(sm.getObjectManager());
        Entity entity = this.get(txn, key);
        this.setAssociatedEntity(sm, txn, entity);
        return entity;
    }

    private void put(StateManager sm, Entity entity) {
        DatastoreTransaction txn = this.put(sm.getObjectManager(), entity);
        this.setAssociatedEntity(sm, txn, entity);
    }

    DatastoreTransaction put(ObjectManager om, Entity entity) {
        DatastoreTransaction txn;
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)("Putting entity of kind " + entity.getKind() + " with key " + entity.getKey()));
            for (Map.Entry entry : entity.getProperties().entrySet()) {
                NucleusLogger.DATASTORE.debug((Object)("  " + (String)entry.getKey() + " : " + entry.getValue()));
            }
        }
        if ((txn = EntityUtils.getCurrentTransaction(om)) == null) {
            this.datastoreService.put(entity);
        } else if (!txn.getDeletedKeys().contains(entity.getKey())) {
            Entity previouslyPut = txn.getPutEntities().get(entity.getKey());
            if (previouslyPut == null || !((Object)previouslyPut.getProperties()).equals(entity.getProperties())) {
                this.datastoreService.put(txn.getInnerTxn(), entity);
            }
            txn.addPutEntity(entity);
        }
        return txn;
    }

    private void delete(ObjectManager om, Key key) {
        NucleusLogger.DATASTORE.debug((Object)("Deleting entity of kind " + key.getKind() + " with key " + key));
        DatastoreTransaction txn = EntityUtils.getCurrentTransaction(om);
        if (txn == null) {
            this.datastoreService.delete(new Key[]{key});
        } else {
            this.datastoreService.delete(txn.getInnerTxn(), new Key[]{key});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertObject(StateManager sm) {
        if (sm.getAssociatedValue(INSERTION_TOKEN) != null) {
            return;
        }
        sm.setAssociatedValue(INSERTION_TOKEN, INSERTION_TOKEN);
        this.storeMgr.validateMetaDataForClass(sm.getClassMetaData(), sm.getObjectManager().getClassLoaderResolver());
        try {
            this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
            String kind = EntityUtils.determineKind(sm.getClassMetaData(), sm.getObjectManager());
            DatastoreFieldManager fieldMgr = new DatastoreFieldManager(sm, kind, this.storeMgr);
            AbstractClassMetaData acmd = sm.getClassMetaData();
            sm.provideFields(acmd.getAllMemberPositions(), (FieldManager)fieldMgr);
            Object assignedParentPk = fieldMgr.establishEntityGroup();
            Entity entity = fieldMgr.getEntity();
            if (fieldMgr.handleIndexFields()) {
                sm.setAssociatedValue(ENTITY_WRITE_DELAYED, (Object)entity);
            } else {
                Integer pkIdPos;
                Object newObjectId;
                this.handleVersioningBeforeWrite(sm, entity, VersionBehavior.INCREMENT, "updating");
                this.put(sm, entity);
                Class pkType = acmd.getMetaDataForManagedMemberAtAbsolutePosition(acmd.getPKMemberPositions()[0]).getType();
                if (pkType.equals(Key.class)) {
                    newObjectId = entity.getKey();
                } else if (pkType.equals(String.class)) {
                    newObjectId = DatastoreManager.hasEncodedPKField(acmd) ? KeyFactory.keyToString((Key)entity.getKey()) : entity.getKey().getName();
                } else if (pkType.equals(Long.class)) {
                    newObjectId = entity.getKey().getId();
                } else {
                    throw new IllegalStateException("Primary key for type " + sm.getClassMetaData().getName() + " is of unexpected type " + pkType.getName() + " (must be String, Long, or " + Key.class.getName() + ")");
                }
                sm.setPostStoreNewObjectId(newObjectId);
                if (assignedParentPk != null) {
                    this.setPostStoreNewParent(sm, fieldMgr.getParentMemberMetaData(), assignedParentPk);
                }
                if ((pkIdPos = fieldMgr.getPkIdPos()) != null) {
                    this.setPostStorePkId(sm, pkIdPos, entity);
                }
                fieldMgr.storeRelations();
                if (this.storeMgr.getRuntimeManager() != null) {
                    this.storeMgr.getRuntimeManager().incrementInsertCount();
                }
            }
        }
        finally {
            sm.setAssociatedValue(INSERTION_TOKEN, null);
        }
    }

    private void setPostStorePkId(StateManager sm, int fieldNumber, Entity entity) {
        sm.replaceField(fieldNumber, (Object)entity.getKey().getId(), true);
    }

    private void setPostStoreNewParent(StateManager sm, AbstractMemberMetaData parentMemberMetaData, Object assignedParentPk) {
        sm.replaceField(parentMemberMetaData.getAbsoluteFieldNumber(), assignedParentPk, true);
    }

    IdentifierFactory getIdentifierFactory(StateManager sm) {
        return ((MappedStoreManager)sm.getObjectManager().getStoreManager()).getIdentifierFactory();
    }

    private NucleusOptimisticException newNucleusOptimisticException(AbstractClassMetaData cmd, Entity entity, String op, String details) {
        return new NucleusOptimisticException("Optimistic concurrency exception " + op + " " + cmd.getFullClassName() + " with pk " + entity.getKey() + ".  " + details);
    }

    private void handleVersioningBeforeWrite(StateManager sm, Entity entity, VersionBehavior versionBehavior, String op) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.hasVersionStrategy()) {
            VersionMetaData vmd = cmd.getVersionMetaData();
            Object curVersion = sm.getObjectManager().getApiAdapter().getVersion(sm);
            if (curVersion != null) {
                Entity refreshedEntity;
                NucleusLogger.DATASTORE.debug((Object)("Getting entity with key " + entity.getKey()));
                try {
                    refreshedEntity = this.datastoreService.get(entity.getKey());
                }
                catch (EntityNotFoundException e) {
                    throw this.newNucleusOptimisticException(cmd, entity, op, "The underlying entity had already been deleted.");
                }
                if (!EntityUtils.getVersionFromEntity(this.getIdentifierFactory(sm), vmd, refreshedEntity).equals(curVersion)) {
                    throw this.newNucleusOptimisticException(cmd, entity, op, "The underlying entity had already been updated.");
                }
            }
            Object nextVersion = cmd.getVersionMetaData().getNextVersion(curVersion);
            sm.setTransactionalVersion(nextVersion);
            String versionPropertyName = EntityUtils.getVersionPropertyName(this.getIdentifierFactory(sm), vmd);
            entity.setProperty(versionPropertyName, nextVersion);
            if (versionBehavior == VersionBehavior.INCREMENT && vmd.getFieldName() != null) {
                AbstractMemberMetaData verfmd = ((AbstractClassMetaData)vmd.getParent()).getMetaDataForMember(vmd.getFieldName());
                sm.replaceField(verfmd.getAbsoluteFieldNumber(), nextVersion, false);
            }
        }
    }

    private static Object getPk(StateManager sm) {
        return sm.getObjectManager().getApiAdapter().getTargetKeyForSingleFieldIdentity(sm.getInternalObjectId());
    }

    private static Key getPkAsKey(StateManager sm) {
        Object pk = DatastorePersistenceHandler.getPk(sm);
        if (pk == null) {
            throw new IllegalStateException("Primary key for object of type " + sm.getClassMetaData().getName() + " is null.");
        }
        return EntityUtils.getPkAsKey(pk, sm.getClassMetaData(), sm.getObjectManager());
    }

    public void setAssociatedEntity(StateManager sm, DatastoreTransaction txn, Entity entity) {
        sm.setAssociatedValue((Object)txn, (Object)entity);
    }

    Entity getAssociatedEntityForCurrentTransaction(StateManager sm) {
        DatastoreTransaction txn = EntityUtils.getCurrentTransaction(sm.getObjectManager());
        return (Entity)sm.getAssociatedValue((Object)txn);
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        if (fieldNumbers == null || fieldNumbers.length == 0) {
            return;
        }
        this.storeMgr.validateMetaDataForClass(sm.getClassMetaData(), sm.getObjectManager().getClassLoaderResolver());
        Entity entity = this.getAssociatedEntityForCurrentTransaction(sm);
        if (entity == null) {
            Key pk = DatastorePersistenceHandler.getPkAsKey(sm);
            entity = this.get(sm, pk);
        }
        sm.replaceFields(fieldNumbers, (FieldManager)new DatastoreFieldManager(sm, this.storeMgr, entity, fieldNumbers));
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.hasVersionStrategy()) {
            sm.setTransactionalVersion(EntityUtils.getVersionFromEntity(this.getIdentifierFactory(sm), cmd.getVersionMetaData(), entity));
        }
        this.runPostFetchMappingCallbacks(sm, fieldNumbers);
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementFetchCount();
        }
    }

    private void runPostFetchMappingCallbacks(StateManager sm, int[] fieldNumbers) {
        AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[fieldNumbers.length];
        for (int i = 0; i < fmds.length; ++i) {
            fmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreTable dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        FetchMappingConsumer consumer = new FetchMappingConsumer(sm.getClassMetaData());
        dc.provideMappingsForMembers(consumer, fmds, true);
        dc.provideDatastoreIdMappings(consumer);
        dc.providePrimaryKeyMappings(consumer);
        for (MappingCallbacks callback : consumer.getMappingCallbacks()) {
            callback.postFetch(sm);
        }
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        this.storeMgr.validateMetaDataForClass(sm.getClassMetaData(), sm.getObjectManager().getClassLoaderResolver());
        Entity entity = this.getAssociatedEntityForCurrentTransaction(sm);
        if (entity == null) {
            Key key = DatastorePersistenceHandler.getPkAsKey(sm);
            entity = this.get(sm, key);
        }
        DatastoreFieldManager fieldMgr = new DatastoreFieldManager(sm, this.storeMgr, entity, fieldNumbers);
        sm.provideFields(fieldNumbers, (FieldManager)fieldMgr);
        this.handleVersioningBeforeWrite(sm, entity, VersionBehavior.INCREMENT, "updating");
        this.put(sm, entity);
        fieldMgr.storeRelations();
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementUpdateCount();
        }
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        this.storeMgr.validateMetaDataForClass(sm.getClassMetaData(), sm.getObjectManager().getClassLoaderResolver());
        Entity entity = this.getAssociatedEntityForCurrentTransaction(sm);
        if (entity == null) {
            Key key = DatastorePersistenceHandler.getPkAsKey(sm);
            entity = this.get(sm, key);
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreTable dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        DatastoreTransaction txn = EntityUtils.getCurrentTransaction(sm.getObjectManager());
        if (txn != null) {
            if (txn.getDeletedKeys().contains(entity.getKey())) {
                return;
            }
            txn.addDeletedKey(entity.getKey());
        }
        DependentDeleteRequest req = new DependentDeleteRequest(dc, clr);
        req.execute(sm, entity);
        DatastoreFieldManager fieldMgr = new DatastoreFieldManager(sm, this.storeMgr, entity);
        AbstractClassMetaData acmd = sm.getClassMetaData();
        sm.provideFields(acmd.getNonPKMemberPositions(), (FieldManager)fieldMgr);
        this.handleVersioningBeforeWrite(sm, entity, VersionBehavior.NO_INCREMENT, "deleting");
        this.delete(sm.getObjectManager(), DatastorePersistenceHandler.getPkAsKey(sm));
    }

    public void locateObject(StateManager sm) {
        this.storeMgr.validateMetaDataForClass(sm.getClassMetaData(), sm.getObjectManager().getClassLoaderResolver());
        this.get(sm, DatastorePersistenceHandler.getPkAsKey(sm));
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    public void close() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VersionBehavior {
        INCREMENT,
        NO_INCREMENT;

    }
}

