/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.appengine.DatastoreProperty;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.IntegerLiteral;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.ObjectLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatastoreQueryExpression
implements QueryExpression {
    private static final Map<String, Query.FilterOperator> FILTER_OPERATOR_MAP = DatastoreQueryExpression.buildFilterOperatorMap();
    private final List<BooleanExpression> andConditions = Utils.newArrayList(new Object[0]);
    private final List<Query.SortPredicate> sortPredicates = Utils.newArrayList(new Object[0]);
    private final DatastoreTable mainTable;
    private final ClassLoaderResolver clr;
    private boolean ignoreSubsequentSorts;
    private static final Field APPENDED_FIELD = DatastoreQueryExpression.getDeclaredFieldQuietly(StatementText.class, "appended");
    private static final Field DATASTORE_FIELD_FIELD = DatastoreQueryExpression.getDeclaredFieldQuietly(ScalarExpression.DatastoreFieldExpression.class, "field");

    DatastoreQueryExpression(DatastoreTable table, ClassLoaderResolver clr) {
        this.mainTable = table;
        this.clr = clr;
    }

    private static String getSymbol(Object op) {
        return op.toString().trim();
    }

    private static Map<String, Query.FilterOperator> buildFilterOperatorMap() {
        HashMap<String, Query.FilterOperator> map = Utils.newHashMap();
        map.put(DatastoreQueryExpression.getSymbol(ScalarExpression.OP_EQ), Query.FilterOperator.EQUAL);
        map.put(DatastoreQueryExpression.getSymbol(ScalarExpression.OP_GT), Query.FilterOperator.GREATER_THAN);
        map.put(DatastoreQueryExpression.getSymbol(ScalarExpression.OP_GTEQ), Query.FilterOperator.GREATER_THAN_OR_EQUAL);
        map.put(DatastoreQueryExpression.getSymbol(ScalarExpression.OP_LT), Query.FilterOperator.LESS_THAN);
        map.put(DatastoreQueryExpression.getSymbol(ScalarExpression.OP_LTEQ), Query.FilterOperator.LESS_THAN_OR_EQUAL);
        return map;
    }

    private static Field getDeclaredFieldQuietly(Class<?> cls, String fieldName) {
        Field field;
        try {
            field = cls.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        field.setAccessible(true);
        return field;
    }

    private List<?> getAppended(StatementText st) {
        try {
            return (List)APPENDED_FIELD.get(st);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private DatastoreProperty getDatastoreProperty(ScalarExpression.DatastoreFieldExpression dfe) {
        try {
            return (DatastoreProperty)DATASTORE_FIELD_FIELD.get(dfe);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    Key getParentKey() {
        if (this.andConditions.size() < 1) {
            return null;
        }
        List<?> appended = this.getAppended(this.andConditions.get(0).toStatementText(ScalarExpression.PROJECTION));
        if (appended.size() != 3) {
            return null;
        }
        if (appended.get(0) instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)appended.get(0);
            try {
                return KeyFactory.stringToKey((String)stringLiteral.getValue().toString());
            }
            catch (IllegalArgumentException iae) {
                String kind = this.getKind((ScalarExpression.DatastoreFieldExpression)appended.get(2));
                return KeyFactory.createKey((String)kind, (String)stringLiteral.getValue().toString());
            }
        }
        if (appended.get(0) instanceof ObjectLiteral) {
            ObjectLiteral objectLiteral = (ObjectLiteral)appended.get(0);
            return (Key)objectLiteral.getValue();
        }
        if (appended.get(0) instanceof IntegerLiteral) {
            IntegerLiteral integerLiteral = (IntegerLiteral)appended.get(0);
            String kind = this.getKind((ScalarExpression.DatastoreFieldExpression)appended.get(2));
            return KeyFactory.createKey((String)kind, (long)((Long)integerLiteral.getValue()));
        }
        return null;
    }

    private String getKind(ScalarExpression.DatastoreFieldExpression dfe) {
        DatastoreProperty prop = this.getDatastoreProperty(dfe);
        return EntityUtils.determineKind(prop.getOwningClassMetaData(), this.mainTable.getStoreManager().getIdentifierFactory());
    }

    Collection<Query.SortPredicate> getSortPredicates() {
        return this.sortPredicates;
    }

    public void setOrdering(ScalarExpression[] exprs, boolean[] descending) {
        if (exprs.length != descending.length) {
            throw new IllegalArgumentException("Expression array and descending array are not the same size.");
        }
        if (this.ignoreSubsequentSorts) {
            return;
        }
        for (int i = 0; i < exprs.length && !this.ignoreSubsequentSorts; ++i) {
            if (!(exprs[i] instanceof ScalarExpression.DatastoreFieldExpression)) {
                throw new UnsupportedOperationException("Expression of type " + exprs[i].getClass().getName() + " not supported.");
            }
            ScalarExpression.DatastoreFieldExpression dfe = (ScalarExpression.DatastoreFieldExpression)exprs[i];
            String propertyName = dfe.toString();
            boolean isPrimaryKey = this.isPrimaryKey(propertyName);
            if (isPrimaryKey) {
                propertyName = "__key__";
            }
            Query.SortPredicate sortPredicate = new Query.SortPredicate(propertyName, descending[i] ? Query.SortDirection.DESCENDING : Query.SortDirection.ASCENDING);
            boolean addPredicate = true;
            if (isPrimaryKey) {
                this.ignoreSubsequentSorts = true;
                if (sortPredicate.getDirection() == Query.SortDirection.ASCENDING && this.sortPredicates.isEmpty()) {
                    addPredicate = false;
                }
            }
            if (!addPredicate) continue;
            this.sortPredicates.add(sortPredicate);
        }
    }

    boolean isPrimaryKey(String propertyName) {
        return this.mainTable.getDatastoreField(propertyName).isPrimaryKey();
    }

    List<Query.FilterPredicate> getFilterPredicates() {
        if (this.andConditions.size() == 1) {
            return Collections.emptyList();
        }
        ArrayList<Object> filters = Utils.newArrayList(new Object[0]);
        for (BooleanExpression expr : this.andConditions.subList(1, this.andConditions.size())) {
            filters.add(this.getFilterPredicate(expr));
        }
        return filters;
    }

    private Query.FilterPredicate getFilterPredicate(BooleanExpression expr) {
        StatementText st = expr.toStatementText(ScalarExpression.PROJECTION);
        List<?> appended = this.getAppended(expr.toStatementText(ScalarExpression.PROJECTION));
        if (!(appended.get(0) instanceof NumericExpression)) {
            throw new UnsupportedOperationException("Cannot transform " + st.toString() + " into a Filter Predicate.");
        }
        NumericExpression numExpr = (NumericExpression)appended.get(0);
        List<?> innerAppended = this.getAppended(numExpr.toStatementText(ScalarExpression.PROJECTION));
        if (innerAppended.size() != 1 || !(innerAppended.get(0) instanceof String)) {
            throw new UnsupportedOperationException("Cannot transform " + st.toString() + " into a Filter Predicate.");
        }
        String propertyName = (String)innerAppended.get(0);
        String opString = (String)appended.get(1);
        if (!(appended.get(2) instanceof IntegerLiteral)) {
            throw new UnsupportedOperationException("Cannot transform " + st.toString() + " into a Filter Predicate.");
        }
        Object value = ((IntegerLiteral)appended.get(2)).getValue();
        Query.FilterOperator op = FILTER_OPERATOR_MAP.get(opString.trim());
        if (op == null) {
            throw new UnsupportedOperationException("Unsupported operator in expression " + st.toString());
        }
        return new Query.FilterPredicate(propertyName, op, value);
    }

    public void andCondition(BooleanExpression condition) {
        this.andConditions.add(condition);
    }

    public void andCondition(BooleanExpression condition, boolean unionQueries) {
        this.andConditions.add(condition);
    }

    public void setParent(QueryExpression parentQueryExpr) {
        throw new UnsupportedOperationException();
    }

    public QueryExpression getParent() {
        throw new UnsupportedOperationException();
    }

    public void setCandidateInformation(Class cls, String alias) {
        throw new UnsupportedOperationException();
    }

    public Class getCandidateClass() {
        throw new UnsupportedOperationException();
    }

    public String getCandidateAlias() {
        throw new UnsupportedOperationException();
    }

    public LogicSetExpression getMainTableExpression() {
        return new LogicSetExpression(this, (DatastoreContainerObject)this.mainTable, null){

            public String referenceColumn(DatastoreField col) {
                return col.getIdentifier().getIdentifierName();
            }

            public String toString() {
                return null;
            }
        };
    }

    public DatastoreIdentifier getMainTableAlias() {
        throw new UnsupportedOperationException();
    }

    public LogicSetExpression getTableExpression(DatastoreIdentifier alias) {
        return null;
    }

    public LogicSetExpression newTableExpression(DatastoreContainerObject mainTable, DatastoreIdentifier alias) {
        throw new UnsupportedOperationException();
    }

    public LogicSetExpression[] newTableExpression(DatastoreContainerObject mainTable, DatastoreIdentifier alias, boolean unionQueries) {
        throw new UnsupportedOperationException();
    }

    public MappedStoreManager getStoreManager() {
        return this.mainTable.getStoreManager();
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    public void setDistinctResults(boolean distinctResults) {
        throw new UnsupportedOperationException();
    }

    public void addExtension(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object getValueForExtension(String key) {
        throw new UnsupportedOperationException();
    }

    public HashMap getExtensions() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMetaDataExpression() {
        return false;
    }

    public int[] selectDatastoreIdentity(String alias, boolean unionQueries) {
        throw new UnsupportedOperationException();
    }

    public int[] selectVersion(String alias, boolean unionQueries) {
        throw new UnsupportedOperationException();
    }

    public int[] selectField(String fieldName, String alias, boolean unionQueries) {
        throw new UnsupportedOperationException();
    }

    public int[] select(JavaTypeMapping mapping) {
        throw new UnsupportedOperationException();
    }

    public int[] select(JavaTypeMapping mapping, boolean unionQueries) {
        return null;
    }

    public int selectScalarExpression(ScalarExpression expr) {
        throw new UnsupportedOperationException();
    }

    public int selectScalarExpression(ScalarExpression expr, boolean unionQueries) {
        throw new UnsupportedOperationException();
    }

    public int[] select(DatastoreIdentifier alias, JavaTypeMapping mapping) {
        throw new UnsupportedOperationException();
    }

    public int[] select(DatastoreIdentifier alias, JavaTypeMapping mapping, boolean unionQueries) {
        throw new UnsupportedOperationException();
    }

    public void crossJoin(LogicSetExpression tableExpr, boolean unionQueries) {
        throw new UnsupportedOperationException();
    }

    public boolean hasCrossJoin(LogicSetExpression tableExpr) {
        throw new UnsupportedOperationException();
    }

    public void innerJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals, boolean unionQueries) {
        throw new UnsupportedOperationException();
    }

    public void innerJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals) {
        throw new UnsupportedOperationException();
    }

    public void leftOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals, boolean unionQueries) {
        throw new UnsupportedOperationException();
    }

    public void leftOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals) {
        throw new UnsupportedOperationException();
    }

    public void rightOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals, boolean unionQueries) {
        throw new UnsupportedOperationException();
    }

    public void rightOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals) {
        throw new UnsupportedOperationException();
    }

    public void addGroupingExpression(ScalarExpression expr) {
        throw new UnsupportedOperationException();
    }

    public void setHaving(BooleanExpression expr) {
        throw new UnsupportedOperationException();
    }

    public void setUpdates(ScalarExpression[] exprs) {
        throw new UnsupportedOperationException();
    }

    public void union(QueryExpression qe) {
        throw new UnsupportedOperationException();
    }

    public void iorCondition(BooleanExpression condition) {
        throw new UnsupportedOperationException();
    }

    public void iorCondition(BooleanExpression condition, boolean unionQueries) {
        throw new UnsupportedOperationException();
    }

    public void setRangeConstraint(long offset, long count) {
        throw new UnsupportedOperationException();
    }

    public void setExistsSubQuery(boolean isExistsSubQuery) {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfScalarExpressions() {
        throw new UnsupportedOperationException();
    }

    public StatementText toDeleteStatementText() {
        throw new UnsupportedOperationException();
    }

    public StatementText toUpdateStatementText() {
        throw new UnsupportedOperationException();
    }

    public StatementText toStatementText(boolean lock) {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNucleusTypeExpression() {
        return false;
    }
}

