/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.dev.CompositeIndexManager;
import com.google.appengine.api.datastore.dev.ValidatedQuery;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public class LocalDatastoreService
implements LocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalDatastoreService.class.getName());
    public static final String MAX_QUERY_LIFETIME_PROPERTY = "datastore.max_query_lifetime";
    private static final int DEFAULT_MAX_QUERY_LIFETIME = 10000;
    public static final String MAX_TRANSACTION_LIFETIME_PROPERTY = "datastore.max_txn_lifetime";
    private static final int DEFAULT_MAX_TRANSACTION_LIFETIME = 10000;
    public static final String STORE_DELAY_PROPERTY = "datastore.store_delay";
    static final int DEFAULT_STORE_DELAY_MS = 30000;
    public static final String BACKING_STORE_PROPERTY = "datastore.backing_store";
    public static final String NO_STORAGE_PROPERTY = "datastore.no_storage";
    static final String ENTITY_GROUP_MESSAGE = "can't operate on multiple entity groups in a single transaction.";
    static final String TWO_UPDATES_SAME_ENTITY_IN_TXN_ERROR_MSG = "can't update the same entity twice in a transaction or operation";
    static final String HANDLE_NOT_FOUND_MESSAGE_FORMAT = "handle %s not found";
    private final AtomicLong entityId = new AtomicLong(1L);
    private final AtomicLong queryId = new AtomicLong(0L);
    private String backingStore;
    private Map<String, Profile> profiles = new HashMap<String, Profile>();
    private final Map<Long, LiveQuery> liveQueries = new HashMap<Long, LiveQuery>();
    private final Map<Long, LiveTxn> liveTxns = new HashMap<Long, LiveTxn>();
    private int maxQueryLifetimeMs;
    private int maxTransactionLifetimeMs;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(2);
    private final RemoveStaleQueries removeStaleQueriesTask = new RemoveStaleQueries();
    private final RemoveStaleTransactions removeStaleTransactionsTask = new RemoveStaleTransactions();
    private final PersistDatastore persistDatastoreTask = new PersistDatastore();
    private final AtomicInteger transactionHandleProvider = new AtomicInteger(0);
    private int storeDelayMs;
    private boolean dirty;
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private boolean noStorage;
    private Thread shutdownHook;
    private static final Comparator<Comparable<Object>> MULTI_TYPE_COMPARATOR = new Comparator<Comparable<Object>>(){

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            Integer comp2TypeRank;
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Integer comp1TypeRank = DataTypeTranslator.getTypeRank(o1.getClass());
            if (comp1TypeRank.equals(comp2TypeRank = Integer.valueOf(DataTypeTranslator.getTypeRank(o2.getClass())))) {
                return o1.compareTo(o2);
            }
            return comp1TypeRank.compareTo(comp2TypeRank);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProfiles() {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            this.profiles.clear();
        }
    }

    public LocalDatastoreService() {
        this.setMaxQueryLifetime(10000);
        this.setMaxTransactionLifetime(10000);
        this.setStoreDelay(30000);
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        String storeFile = properties.get(BACKING_STORE_PROPERTY);
        if (storeFile == null) {
            File dir = GenerationDirectory.getGenerationDirectory((File)context.getAppDir());
            dir.mkdirs();
            storeFile = dir.getAbsolutePath() + File.separator + "local_db.bin";
        }
        this.setBackingStore(storeFile);
        String noStorageProp = properties.get(NO_STORAGE_PROPERTY);
        if (noStorageProp != null) {
            this.noStorage = Boolean.valueOf(noStorageProp);
        }
        String storeDelayTime = properties.get(STORE_DELAY_PROPERTY);
        this.storeDelayMs = LocalDatastoreService.parseInt(storeDelayTime, this.storeDelayMs, STORE_DELAY_PROPERTY);
        String maxQueryLifetime = properties.get(MAX_QUERY_LIFETIME_PROPERTY);
        this.maxQueryLifetimeMs = LocalDatastoreService.parseInt(maxQueryLifetime, this.maxQueryLifetimeMs, MAX_QUERY_LIFETIME_PROPERTY);
        String maxTxnLifetime = properties.get(MAX_TRANSACTION_LIFETIME_PROPERTY);
        this.maxTransactionLifetimeMs = LocalDatastoreService.parseInt(maxTxnLifetime, this.maxTransactionLifetimeMs, MAX_TRANSACTION_LIFETIME_PROPERTY);
        CompositeIndexManager.getInstance().setAppDir(context.getAppDir());
    }

    private static int parseInt(String valStr, int defaultVal, String propName) {
        if (valStr != null) {
            try {
                return Integer.parseInt(valStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Expected a numeric value for property " + propName + "but received, " + valStr + ". Resetting property to the default.");
            }
        }
        return defaultVal;
    }

    public void start() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LocalDatastoreService.this.start_();
                return null;
            }
        });
    }

    private void start_() {
        if (!this.noStorage) {
            this.load();
        }
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.scheduleWithFixedDelay(this.removeStaleQueriesTask, this.maxQueryLifetimeMs * 5, this.maxQueryLifetimeMs * 5, TimeUnit.MILLISECONDS);
        this.scheduler.scheduleWithFixedDelay(this.removeStaleTransactionsTask, this.maxTransactionLifetimeMs * 5, this.maxTransactionLifetimeMs * 5, TimeUnit.MILLISECONDS);
        if (!this.noStorage) {
            this.scheduler.scheduleWithFixedDelay(this.persistDatastoreTask, this.storeDelayMs, this.storeDelayMs, TimeUnit.MILLISECONDS);
        }
        this.shutdownHook = new Thread(){

            public void run() {
                LocalDatastoreService.this.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.scheduler.shutdown();
        if (!this.noStorage) {
            this.persistDatastoreTask.run();
        }
        Map<Long, HasCreationTime> map = this.liveQueries;
        synchronized (map) {
            this.liveQueries.clear();
        }
        map = this.liveTxns;
        synchronized (map) {
            this.liveTxns.clear();
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void setMaxQueryLifetime(int milliseconds) {
        this.maxQueryLifetimeMs = milliseconds;
    }

    public void setMaxTransactionLifetime(int milliseconds) {
        this.maxTransactionLifetimeMs = milliseconds;
    }

    public void setBackingStore(String backingStore) {
        this.backingStore = backingStore;
    }

    public void setStoreDelay(int delayMs) {
        this.storeDelayMs = delayMs;
    }

    public void setNoStorage(boolean noStorage) {
        this.noStorage = noStorage;
    }

    public String getPackage() {
        return "datastore_v3";
    }

    private String getIdOrName(OnestoreEntity.Path.Element path) {
        if (path.hasName()) {
            return path.getName();
        }
        return Long.toString(path.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.GetResponse get(LocalRpcService.Status status, DatastorePb.GetRequest request) {
        DatastorePb.GetResponse response = new DatastorePb.GetResponse();
        LiveTxn liveTxn = null;
        for (OnestoreEntity.Reference key : request.keys()) {
            Extent extent;
            Profile profile;
            String app = key.getApp();
            if (request.hasTransaction()) {
                if (liveTxn == null) {
                    liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, request.getTransaction().getHandle());
                }
                liveTxn.setEntityGroup(this.getGroup(key));
            }
            OnestoreEntity.Path.Element lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
            DatastorePb.GetResponse.Entity group = response.addEntity();
            Map<String, Profile> map = this.profiles;
            synchronized (map) {
                profile = this.profiles.get(app);
            }
            if (profile == null) continue;
            Map<String, Extent> extents = profile.getExtents();
            Object object = extents;
            synchronized (object) {
                extent = extents.get(lastPath.getType());
            }
            if (extent == null) continue;
            object = extent;
            synchronized (object) {
                Map<String, OnestoreEntity.EntityProto> entities = extent.getEntities();
                OnestoreEntity.EntityProto entity = entities.get(this.getIdOrName(lastPath));
                if (entity != null) {
                    group.getMutableEntity().copyFrom((ProtocolMessage)entity);
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.PutResponse put(LocalRpcService.Status status, DatastorePb.PutRequest request) {
        try {
            this.globalLock.readLock().lock();
            DatastorePb.PutResponse putResponse = this.putImpl(status, request);
            return putResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.PutResponse putImpl(LocalRpcService.Status status, DatastorePb.PutRequest request) {
        DatastorePb.PutResponse response = new DatastorePb.PutResponse();
        ArrayList<OnestoreEntity.EntityProto> clones = new ArrayList<OnestoreEntity.EntityProto>();
        String app = null;
        Profile profile = null;
        LiveTxn liveTxn = null;
        for (OnestoreEntity.EntityProto entity : request.entitys()) {
            OnestoreEntity.EntityProto clone = (OnestoreEntity.EntityProto)entity.clone();
            clones.add(clone);
            assert (clone.hasKey());
            OnestoreEntity.Reference key = clone.getKey();
            assert (key.getPath().elementSize() > 0);
            if (app == null) {
                app = key.getApp();
                profile = this.getOrCreateProfile(app);
            }
            clone.getMutableKey().setApp(app);
            OnestoreEntity.Path.Element lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
            if (!lastPath.hasId() && !lastPath.hasName()) {
                lastPath.setId(this.entityId.getAndIncrement());
            }
            if (clone.getEntityGroup().elementSize() == 0) {
                OnestoreEntity.Path group = clone.getMutableEntityGroup();
                OnestoreEntity.Path.Element root = (OnestoreEntity.Path.Element)key.getPath().elements().get(0);
                OnestoreEntity.Path.Element pathElement = group.addElement();
                pathElement.setType(root.getType());
                if (root.hasName()) {
                    pathElement.setName(root.getName());
                } else {
                    pathElement.setId(root.getId());
                }
            } else assert (clone.hasEntityGroup() && clone.getEntityGroup().elementSize() > 0);
            if (!request.hasTransaction()) continue;
            if (liveTxn == null) {
                liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, request.getTransaction().getHandle());
            }
            liveTxn.setEntityGroup(clone.getEntityGroup());
            try {
                liveTxn.addKeyOfModifiedEntity(clone.getKey());
            }
            catch (IllegalArgumentException iae) {
                throw new RuntimeException(request.toString());
            }
        }
        for (OnestoreEntity.EntityProto clone : clones) {
            Extent extent;
            OnestoreEntity.Path.Element lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(clone.getKey().getPath().elements());
            String kind = lastPath.getType();
            Extent extent2 = extent = this.getOrCreateExtent(profile, kind);
            synchronized (extent2) {
                extent.getEntities().put(this.getIdOrName(lastPath), clone);
            }
            response.mutableKeys().add(clone.getKey());
        }
        if (clones.size() > 0) {
            this.dirty = true;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.DeleteResponse delete(LocalRpcService.Status status, DatastorePb.DeleteRequest request) {
        try {
            this.globalLock.readLock().lock();
            DatastorePb.DeleteResponse deleteResponse = this.deleteImpl(status, request);
            return deleteResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private OnestoreEntity.Path getGroup(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        OnestoreEntity.Path group = new OnestoreEntity.Path();
        group.addElement(path.getElement(0));
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.DeleteResponse deleteImpl(LocalRpcService.Status status, DatastorePb.DeleteRequest request) {
        LiveTxn liveTxn = null;
        for (OnestoreEntity.Reference key : request.keys()) {
            String app = key.getApp();
            if (request.hasTransaction()) {
                if (liveTxn == null) {
                    liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, request.getTransaction().getHandle());
                }
                liveTxn.setEntityGroup(this.getGroup(key));
                liveTxn.addKeyOfModifiedEntity(key);
            }
            Map<String, Profile> map = this.profiles;
            synchronized (map) {
                Map<String, Extent> extents;
                Profile profile = this.profiles.get(app);
                if (profile == null) {
                    continue;
                }
                OnestoreEntity.Path.Element lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
                String kind = lastPath.getType();
                Map<String, Extent> map2 = extents = profile.getExtents();
                synchronized (map2) {
                    Extent extent = profile.getExtents().get(kind);
                    if (extent == null) {
                        continue;
                    }
                    Extent extent2 = extent;
                    synchronized (extent2) {
                        if (extent.getEntities().remove(this.getIdOrName(lastPath)) != null) {
                            this.dirty = true;
                        }
                    }
                }
            }
        }
        return new DatastorePb.DeleteResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.QueryResult runQuery(LocalRpcService.Status status, final DatastorePb.Query query) {
        Profile profile;
        final ValidatedQuery validatedQuery = new ValidatedQuery(query);
        DatastorePb.QueryResult result = new DatastorePb.QueryResult();
        String app = query.getApp();
        Iterable<Object> queryEntities = null;
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            profile = this.profiles.get(app);
        }
        if (profile != null) {
            Extent extent;
            Map<String, Extent> extents = profile.getExtents();
            Object object = extents;
            synchronized (object) {
                extent = extents.get(query.getKind());
            }
            if (extent != null) {
                object = extent;
                synchronized (object) {
                    queryEntities = extent.getEntities().values();
                }
            }
        }
        if (queryEntities == null) {
            queryEntities = Collections.emptyList();
        }
        if (query.hasAncestor()) {
            final List ancestorPath = query.getAncestor().getPath().elements();
            queryEntities = Iterables.filter(queryEntities, (Predicate)new Predicate<OnestoreEntity.EntityProto>(){

                public boolean apply(OnestoreEntity.EntityProto entity) {
                    List path = entity.getKey().getPath().elements();
                    return path.size() >= ancestorPath.size() && ((Object)path.subList(0, ancestorPath.size())).equals(ancestorPath);
                }
            });
        }
        ArrayList<Object> filteredResults = new ArrayList<OnestoreEntity.EntityProto>();
        block9: for (OnestoreEntity.EntityProto queryEntity : queryEntities) {
            for (DatastorePb.Query.Filter filter : query.filters()) {
                OnestoreEntity.Property filterProperty = filter.getProperty(0);
                Comparable filterValue = DataTypeTranslator.getComparablePropertyValue((OnestoreEntity.Property)filterProperty);
                assert (filter.getOpEnum() != DatastorePb.Query.Filter.Operator.IN);
                Collection entityProps = DataTypeTranslator.findIndexedPropertiesOnPb((OnestoreEntity.EntityProto)queryEntity, (String)filterProperty.getName());
                if (entityProps.isEmpty()) continue block9;
                boolean atLeastOneValueMatches = false;
                for (OnestoreEntity.Property entityProp : entityProps) {
                    Comparable singleValue = DataTypeTranslator.getComparablePropertyValue((OnestoreEntity.Property)entityProp);
                    if (!this.matches(singleValue, filterValue, filter.getOpEnum())) continue;
                    atLeastOneValueMatches = true;
                    break;
                }
                if (atLeastOneValueMatches) continue;
                continue block9;
            }
            filteredResults.add(queryEntity);
        }
        HashSet<String> orderProperties = new HashSet<String>();
        for (DatastorePb.Query.Order order : query.orders()) {
            orderProperties.add(order.getProperty());
        }
        HashMap entityProperties = new HashMap();
        Iterator protoIt = filteredResults.iterator();
        while (protoIt.hasNext()) {
            OnestoreEntity.EntityProto proto = (OnestoreEntity.EntityProto)protoIt.next();
            DataTypeTranslator.extractIndexedPropertiesFromPb((OnestoreEntity.EntityProto)proto, entityProperties);
            DataTypeTranslator.extractImplicitPropertiesFromPb((OnestoreEntity.EntityProto)proto, entityProperties);
            if (entityProperties.keySet().containsAll(orderProperties)) continue;
            protoIt.remove();
        }
        Comparator<OnestoreEntity.EntityProto> sortComparator = new Comparator<OnestoreEntity.EntityProto>(){

            @Override
            public int compare(OnestoreEntity.EntityProto protoA, OnestoreEntity.EntityProto protoB) {
                for (DatastorePb.Query.Order order : query.orders()) {
                    int result;
                    String property = order.getProperty();
                    try {
                        List<Comparable<Object>> aValues = LocalDatastoreService.getComparablePropertyValues(protoA, property);
                        List<Comparable<Object>> bValues = LocalDatastoreService.getComparablePropertyValues(protoB, property);
                        Comparable<Object> minA = LocalDatastoreService.multiTypeMin(aValues);
                        Comparable<Object> minB = LocalDatastoreService.multiTypeMin(bValues);
                        result = MULTI_TYPE_COMPARATOR.compare(minA, minB);
                    }
                    catch (NonExistentPropertyException e) {
                        throw new IllegalStateException("Trying to sort on a non-existent property.");
                    }
                    if (result == 0) continue;
                    if (order.getDirectionEnum() == DatastorePb.Query.Order.Direction.DESCENDING) {
                        result = -result;
                    }
                    return result;
                }
                return 0;
            }
        };
        Collections.sort(filteredResults, sortComparator);
        if (query.hasOffset()) {
            int offset = Math.min(filteredResults.size(), query.getOffset());
            filteredResults = new ArrayList(filteredResults.subList(offset, filteredResults.size()));
        }
        if (query.hasLimit()) {
            int limit = Math.min(filteredResults.size(), query.getLimit());
            filteredResults = new ArrayList(filteredResults.subList(0, limit));
        }
        long cursor = this.queryId.getAndIncrement();
        this.liveQueries.put(cursor, new LiveQuery(filteredResults, System.currentTimeMillis()));
        result.getMutableCursor().setCursor(cursor);
        result.setMoreResults(filteredResults.size() > 0);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                CompositeIndexManager.getInstance().processQuery(validatedQuery);
                return null;
            }
        });
        return result;
    }

    static Comparable<Object> multiTypeMin(Collection<Comparable<Object>> comparables) {
        Comparable<Object> smallest = null;
        for (Comparable<Object> comp : comparables) {
            if (smallest == null) {
                smallest = comp;
                continue;
            }
            if (MULTI_TYPE_COMPARATOR.compare(comp, smallest) >= 0) continue;
            smallest = comp;
        }
        return smallest;
    }

    static List<Comparable<Object>> getComparablePropertyValues(OnestoreEntity.EntityProto entityProto, String propertyName) throws NonExistentPropertyException {
        Collection entityProperties = DataTypeTranslator.findIndexedPropertiesOnPb((OnestoreEntity.EntityProto)entityProto, (String)propertyName);
        if (entityProperties.isEmpty()) {
            throw new NonExistentPropertyException();
        }
        ArrayList<Comparable<Object>> values = new ArrayList<Comparable<Object>>(entityProperties.size());
        for (OnestoreEntity.Property prop : entityProperties) {
            values.add(DataTypeTranslator.getComparablePropertyValue((OnestoreEntity.Property)prop));
        }
        return values;
    }

    private static <T> T safeGetFromExpiringMap(Map<Long, T> map, long key) {
        T value = map.get(key);
        if (value == null) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), String.format(HANDLE_NOT_FOUND_MESSAGE_FORMAT, key));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.QueryResult next(LocalRpcService.Status status, DatastorePb.NextRequest request) {
        List<OnestoreEntity.EntityProto> queryContents;
        DatastorePb.QueryResult result = new DatastorePb.QueryResult();
        long cursorId = request.getCursor().getCursor();
        Map<Long, LiveQuery> map = this.liveQueries;
        synchronized (map) {
            queryContents = LocalDatastoreService.safeGetFromExpiringMap(this.liveQueries, cursorId).getEntities();
        }
        int count = request.getCount();
        int end = Math.min(count, queryContents.size());
        List<OnestoreEntity.EntityProto> subList = queryContents.subList(0, end);
        ArrayList<OnestoreEntity.EntityProto> nextResults = new ArrayList<OnestoreEntity.EntityProto>(subList);
        subList.clear();
        for (OnestoreEntity.EntityProto proto : nextResults) {
            result.addResult(proto);
        }
        result.setMoreResults(queryContents.size() > 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiBasePb.Integer64Proto count(LocalRpcService.Status status, DatastorePb.Query request) {
        List<OnestoreEntity.EntityProto> queryData;
        LocalRpcService.Status queryStatus = new LocalRpcService.Status();
        DatastorePb.QueryResult queryResult = this.runQuery(queryStatus, request);
        long cursor = queryResult.getCursor().getCursor();
        Map<Long, LiveQuery> map = this.liveQueries;
        synchronized (map) {
            queryData = LocalDatastoreService.safeGetFromExpiringMap(this.liveQueries, cursor).getEntities();
            this.liveQueries.remove(cursor);
        }
        ApiBasePb.Integer64Proto results = new ApiBasePb.Integer64Proto();
        results.setValue((long)queryData.size());
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiBasePb.VoidProto deleteCursor(LocalRpcService.Status status, DatastorePb.Cursor request) {
        Map<Long, LiveQuery> map = this.liveQueries;
        synchronized (map) {
            this.liveQueries.remove(request.getCursor());
        }
        return new ApiBasePb.VoidProto();
    }

    public DatastorePb.QueryExplanation explain(LocalRpcService.Status status, DatastorePb.Query req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public DatastorePb.Transaction beginTransaction(LocalRpcService.Status status, ApiBasePb.VoidProto req) {
        DatastorePb.Transaction txn = new DatastorePb.Transaction().setHandle((long)this.transactionHandleProvider.getAndIncrement());
        this.liveTxns.put(txn.getHandle(), new LiveTxn(System.currentTimeMillis()));
        return txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLiveTxn(long handle) {
        Map<Long, LiveTxn> map = this.liveTxns;
        synchronized (map) {
            LiveTxn txn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, handle);
            this.liveTxns.remove(handle);
        }
    }

    public DatastorePb.CommitResponse commit(LocalRpcService.Status status, DatastorePb.Transaction req) {
        this.removeLiveTxn(req.getHandle());
        return new DatastorePb.CommitResponse();
    }

    public ApiBasePb.VoidProto rollback(LocalRpcService.Status status, DatastorePb.Transaction req) {
        this.removeLiveTxn(req.getHandle());
        return new ApiBasePb.VoidProto();
    }

    public DatastorePb.Schema getSchema(LocalRpcService.Status status, ApiBasePb.StringProto req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ApiBasePb.Integer64Proto createIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ApiBasePb.VoidProto updateIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public DatastorePb.CompositeIndices getIndices(LocalRpcService.Status status, ApiBasePb.StringProto req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ApiBasePb.VoidProto deleteIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Profile getOrCreateProfile(String app) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            Profile profile = this.profiles.get(app);
            if (profile == null) {
                profile = new Profile();
                this.profiles.put(app, profile);
            }
            return profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extent getOrCreateExtent(Profile profile, String kind) {
        Map<String, Extent> extents;
        Map<String, Extent> map = extents = profile.getExtents();
        synchronized (map) {
            Extent e = extents.get(kind);
            if (e == null) {
                e = new Extent();
                extents.put(kind, e);
            }
            return e;
        }
    }

    private boolean matches(Comparable<Object> value1, Comparable<Object> value2, DatastorePb.Query.Filter.Operator op) {
        switch (op) {
            case EQUAL: {
                return MULTI_TYPE_COMPARATOR.compare(value1, value2) == 0;
            }
            case GREATER_THAN: {
                return MULTI_TYPE_COMPARATOR.compare(value1, value2) > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                return MULTI_TYPE_COMPARATOR.compare(value1, value2) >= 0;
            }
            case LESS_THAN: {
                return MULTI_TYPE_COMPARATOR.compare(value1, value2) < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return MULTI_TYPE_COMPARATOR.compare(value1, value2) <= 0;
            }
        }
        throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), "Unable to perform filter using operator " + op);
    }

    private void load() {
        File backingStoreFile = new File(this.backingStore);
        String path = backingStoreFile.getAbsolutePath();
        if (!backingStoreFile.exists()) {
            logger.log(Level.INFO, "The backing store, " + path + ", does not exist. " + "It will be created.");
            return;
        }
        try {
            Map profilesOnDisk;
            long start = System.currentTimeMillis();
            ObjectInputStream objectIn = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.backingStore)));
            this.entityId.set(objectIn.readLong());
            this.profiles = profilesOnDisk = (Map)objectIn.readObject();
            objectIn.close();
            long end = System.currentTimeMillis();
            logger.log(Level.INFO, "Time to load datastore: " + (end - start) + " ms");
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to find the backing store, " + path);
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Failed to load from the backing store, " + path, e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.INFO, "Failed to load from the backing store, " + path, e);
        }
    }

    private static <T> T getLast(List<T> list) {
        return list.get(list.size() - 1);
    }

    static void pruneHasCreationTimeMap(long now, int maxLifetimeMs, Map<Long, ? extends HasCreationTime> hasCreationTimeMap) {
        long deadline = now - (long)maxLifetimeMs;
        Iterator<Map.Entry<Long, ? extends HasCreationTime>> queryIt = hasCreationTimeMap.entrySet().iterator();
        while (queryIt.hasNext()) {
            Map.Entry<Long, ? extends HasCreationTime> entry = queryIt.next();
            HasCreationTime query = entry.getValue();
            if (query.getCreationTime() >= deadline) continue;
            queryIt.remove();
        }
    }

    void removeStaleQueriesNow() {
        this.removeStaleQueriesTask.run();
    }

    void removeStaleTxnsNow() {
        this.removeStaleTransactionsTask.run();
    }

    private class PersistDatastore
    implements Runnable {
        private PersistDatastore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                LocalDatastoreService.this.globalLock.writeLock().lock();
                this.privilegedPersist();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unable to save the datastore", e);
            }
            finally {
                LocalDatastoreService.this.globalLock.writeLock().unlock();
            }
        }

        private void privilegedPersist() throws IOException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        PersistDatastore.this.persist();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new RuntimeException(t);
            }
        }

        private void persist() throws IOException {
            if (!LocalDatastoreService.this.dirty) {
                return;
            }
            long start = System.currentTimeMillis();
            ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(LocalDatastoreService.this.backingStore)));
            objectOut.writeLong(LocalDatastoreService.this.entityId.get());
            objectOut.writeObject(LocalDatastoreService.this.profiles);
            objectOut.close();
            LocalDatastoreService.this.dirty = false;
            long end = System.currentTimeMillis();
            logger.log(Level.INFO, "Time to persist datastore: " + (end - start) + " ms");
        }
    }

    private class RemoveStaleTransactions
    implements Runnable {
        private RemoveStaleTransactions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = LocalDatastoreService.this.liveTxns;
            synchronized (map) {
                LocalDatastoreService.pruneHasCreationTimeMap(System.currentTimeMillis(), LocalDatastoreService.this.maxTransactionLifetimeMs, LocalDatastoreService.this.liveTxns);
            }
        }
    }

    private class RemoveStaleQueries
    implements Runnable {
        private RemoveStaleQueries() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = LocalDatastoreService.this.liveQueries;
            synchronized (map) {
                LocalDatastoreService.pruneHasCreationTimeMap(System.currentTimeMillis(), LocalDatastoreService.this.maxQueryLifetimeMs, LocalDatastoreService.this.liveQueries);
            }
        }
    }

    static class LiveTxn
    extends HasCreationTime {
        private OnestoreEntity.Path entityGroup;
        private final Set<OnestoreEntity.Reference> modified = Collections.synchronizedSet(new HashSet());

        public LiveTxn(long creationTime) {
            super(creationTime);
        }

        public synchronized void setEntityGroup(OnestoreEntity.Path newEntityGroup) {
            if (newEntityGroup == null) {
                throw new NullPointerException("entityGroup cannot be null");
            }
            if (this.entityGroup != null && !this.entityGroup.equals(newEntityGroup)) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "can't operate on multiple entity groups in a single transaction. found both " + this.entityGroup + " and " + newEntityGroup);
            }
            this.entityGroup = newEntityGroup;
        }

        public void addKeyOfModifiedEntity(OnestoreEntity.Reference key) {
            if (!this.modified.add(key)) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), LocalDatastoreService.TWO_UPDATES_SAME_ENTITY_IN_TXN_ERROR_MSG);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LiveQuery
    extends HasCreationTime {
        private final List<OnestoreEntity.EntityProto> entities;

        public LiveQuery(List<OnestoreEntity.EntityProto> entities, long creationTime) {
            super(creationTime);
            if (entities == null) {
                throw new NullPointerException("entities cannot be null");
            }
            this.entities = entities;
        }

        public List<OnestoreEntity.EntityProto> getEntities() {
            return this.entities;
        }
    }

    static abstract class HasCreationTime {
        private final long creationTime;

        HasCreationTime(long creationTime) {
            this.creationTime = creationTime;
        }

        long getCreationTime() {
            return this.creationTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Extent
    implements Serializable {
        private Map<String, OnestoreEntity.EntityProto> entities = new LinkedHashMap<String, OnestoreEntity.EntityProto>();

        private Extent() {
        }

        public Map<String, OnestoreEntity.EntityProto> getEntities() {
            return this.entities;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Profile
    implements Serializable {
        private Map<String, Extent> extents = new HashMap<String, Extent>();

        private Profile() {
        }

        public Map<String, Extent> getExtents() {
            return this.extents;
        }
    }

    static final class NonExistentPropertyException
    extends Exception {
        NonExistentPropertyException() {
        }
    }
}

