/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch;

public final class FetchOptions {
    public static final boolean DEFAULT_ALLOW_TRUNCATE = false;
    public static final boolean DEFAULT_FOLLOW_REDIRECTS = true;
    private boolean allowTruncate = false;
    private boolean followRedirects = true;

    private FetchOptions() {
    }

    public FetchOptions allowTruncate() {
        this.allowTruncate = true;
        return this;
    }

    public FetchOptions disallowTruncate() {
        this.allowTruncate = false;
        return this;
    }

    public FetchOptions followRedirects() {
        this.followRedirects = true;
        return this;
    }

    public FetchOptions doNotFollowRedirects() {
        this.followRedirects = false;
        return this;
    }

    boolean getAllowTruncate() {
        return this.allowTruncate;
    }

    boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public static final class Builder {
        public static FetchOptions allowTruncate() {
            return Builder.withDefaults().allowTruncate();
        }

        public static FetchOptions disallowTruncate() {
            return Builder.withDefaults().disallowTruncate();
        }

        public static FetchOptions followRedirects() {
            return Builder.withDefaults().followRedirects();
        }

        public static FetchOptions doNotFollowRedirects() {
            return Builder.withDefaults().doNotFollowRedirects();
        }

        static FetchOptions withDefaults() {
            return new FetchOptions();
        }

        private Builder() {
        }
    }
}

