/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.JavaScriptBackgroundJob;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;

public class ThreadManager {
    private static final Log LOG = LogFactory.getLog(ThreadManager.class);
    private Map<Integer, Thread> threadMap_ = Collections.synchronizedMap(new TreeMap());
    private final WeakReference<WebWindow> window_;
    private static AtomicInteger NEXT_THREAD_ID_ = new AtomicInteger(1);
    private static final int PRIORITY = Math.min(10, Thread.currentThread().getPriority() + 1);

    ThreadManager(WebWindow window) {
        this.window_ = new WeakReference<WebWindow>(window);
    }

    public int activeCount() {
        return this.threadMap_.size();
    }

    public int startThread(Runnable job, String label) {
        if (job == null) {
            return 0;
        }
        WebWindow ww = (WebWindow)this.window_.get();
        if (ww == null) {
            return 0;
        }
        final int threadId = NEXT_THREAD_ID_.getAndIncrement();
        Thread newThread = new Thread(job, "HtmlUnit Managed Thread #" + threadId + " for WebWindow " + ww.getName() + ": " + label){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    super.run();
                }
                finally {
                    ThreadManager.this.threadMap_.remove(new Integer(threadId));
                }
            }
        };
        newThread.setPriority(PRIORITY);
        newThread.setDaemon(true);
        this.threadMap_.put(new Integer(threadId), newThread);
        newThread.start();
        return threadId;
    }

    public void stopThread(int threadID) {
        Thread thread = this.threadMap_.get(new Integer(threadID));
        if (thread != null) {
            thread.interrupt();
        }
    }

    public void removeJob(int id) {
        this.stopThread(id);
    }

    public boolean joinAll(long maxWaitMillis) {
        Thread t = this.getNextThread();
        while (t != null && maxWaitMillis > 0L) {
            long before = System.currentTimeMillis();
            try {
                LOG.debug((Object)("Trying to join: " + t));
                t.join(maxWaitMillis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread " + t + " interrupted.", e);
            }
            maxWaitMillis -= System.currentTimeMillis() - before;
            t = this.getNextThread();
        }
        return this.threadMap_.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getNextThread() {
        Thread thread;
        Map<Integer, Thread> map = this.threadMap_;
        synchronized (map) {
            Iterator<Thread> i = this.threadMap_.values().iterator();
            thread = i.hasNext() ? i.next() : null;
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAll() {
        Map<Integer, Thread> map = this.threadMap_;
        synchronized (map) {
            for (Integer id : new HashSet<Integer>(this.threadMap_.keySet())) {
                this.stopThread(id);
            }
        }
    }

    public String toString() {
        return "ThreadManager: " + this.threadMap_;
    }

    public int registerJob(Object codeToExec, int timeout, String description) {
        JavaScriptBackgroundJob job = this.createJavaScriptBackgroundJob(codeToExec, timeout, false, description);
        return this.startThread(job, description);
    }

    public int registerRecurringJob(Object codeToExec, int interval, String description) {
        JavaScriptBackgroundJob job = this.createJavaScriptBackgroundJob(codeToExec, interval, true, description);
        return this.startThread(job, description);
    }

    private JavaScriptBackgroundJob createJavaScriptBackgroundJob(Object codeToExec, int timeout, boolean loopForever, String label) {
        WebWindow ww = (WebWindow)this.window_.get();
        if (ww == null) {
            return null;
        }
        Window thisWindow = (Window)ww.getScriptObject();
        if (codeToExec == null) {
            throw Context.reportRuntimeError((String)"Function not provided");
        }
        if (codeToExec instanceof String) {
            String scriptString = (String)codeToExec;
            return new JavaScriptBackgroundJob(thisWindow, timeout, scriptString, loopForever, label);
        }
        if (codeToExec instanceof Function) {
            Function scriptFunction = (Function)codeToExec;
            return new JavaScriptBackgroundJob(thisWindow, timeout, scriptFunction, loopForever, label);
        }
        throw Context.reportRuntimeError((String)"Unknown type for function");
    }
}

