/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.util.EventObject;

public final class WebWindowEvent
extends EventObject {
    private static final long serialVersionUID = 6693838158619061745L;
    private final Page oldPage_;
    private final Page newPage_;
    private final int type_;
    public static final int OPEN = 1;
    public static final int CLOSE = 2;
    public static final int CHANGE = 3;

    public WebWindowEvent(WebWindow webWindow, int type, Page oldPage, Page newPage) {
        super(webWindow);
        this.oldPage_ = oldPage;
        this.newPage_ = newPage;
        switch (type) {
            case 1: 
            case 2: 
            case 3: {
                this.type_ = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("type must be one of OPEN, CLOSE, CHANGE but got " + type);
            }
        }
    }

    public boolean equals(Object object) {
        if (this.getClass() == object.getClass()) {
            WebWindowEvent event = (WebWindowEvent)object;
            return this.isEqual(this.getSource(), event.getSource()) && this.getEventType() == event.getEventType() && this.isEqual(this.getOldPage(), event.getOldPage()) && this.isEqual(this.getNewPage(), event.getNewPage());
        }
        return false;
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public Page getOldPage() {
        return this.oldPage_;
    }

    public Page getNewPage() {
        return this.newPage_;
    }

    public WebWindow getWebWindow() {
        return (WebWindow)this.getSource();
    }

    private boolean isEqual(Object object1, Object object2) {
        boolean result = object1 == null && object2 == null ? true : (object1 == null || object2 == null ? false : object1.equals(object2));
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(80);
        buffer.append("WebWindowEvent(source=[");
        buffer.append(this.getSource());
        buffer.append("] type=[");
        switch (this.type_) {
            case 1: {
                buffer.append("OPEN");
                break;
            }
            case 2: {
                buffer.append("CLOSE");
                break;
            }
            case 3: {
                buffer.append("CHANGE");
                break;
            }
            default: {
                buffer.append(this.type_);
            }
        }
        buffer.append("] oldPage=[");
        buffer.append(this.getOldPage());
        buffer.append("] newPage=[");
        buffer.append(this.getNewPage());
        buffer.append("])");
        return buffer.toString();
    }

    public int getEventType() {
        return this.type_;
    }
}

