/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.IEConditionalCompilationScriptPreProcessor;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptEngine
implements Serializable {
    private static final long serialVersionUID = -5414040051465432088L;
    private final WebClient webClient_;
    private final HtmlUnitContextFactory contextFactory_;
    private static final Log ScriptEngineLog_ = LogFactory.getLog(JavaScriptEngine.class);
    private static final ThreadLocal<Boolean> javaScriptRunning_ = new ThreadLocal();
    private static final ThreadLocal<List<PostponedAction>> postponedActions_ = new ThreadLocal();
    public static final String KEY_STARTING_SCOPE = "startingScope";

    public JavaScriptEngine(WebClient webClient) {
        this.webClient_ = webClient;
        this.contextFactory_ = new HtmlUnitContextFactory(webClient.getBrowserVersion(), JavaScriptEngine.getScriptEngineLog());
    }

    public final WebClient getWebClient() {
        return this.webClient_;
    }

    public HtmlUnitContextFactory getContextFactory() {
        return this.contextFactory_;
    }

    public void initialize(final WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        ContextAction action = new ContextAction(){

            public Object run(Context cx) {
                try {
                    JavaScriptEngine.this.init(webWindow, cx);
                }
                catch (Exception e) {
                    JavaScriptEngine.this.getLog().error((Object)"Exception while initializing JavaScript for the page", (Throwable)e);
                    throw new ScriptException(null, (Throwable)e);
                }
                return null;
            }
        };
        this.getContextFactory().call(action);
    }

    private void init(WebWindow webWindow, Context context) throws Exception {
        WebClient webClient = webWindow.getWebClient();
        HashMap<Class<? extends SimpleScriptable>, Scriptable> prototypes = new HashMap<Class<? extends SimpleScriptable>, Scriptable>();
        HashMap<String, Scriptable> prototypesPerJSName = new HashMap<String, Scriptable>();
        Window window = new Window(this);
        JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(webClient.getBrowserVersion());
        context.initStandardObjects((ScriptableObject)window);
        ScriptableObject fallbackCaller = new ScriptableObject(){
            private static final long serialVersionUID = -7124423159070941606L;

            public Object get(String name, Scriptable start) {
                if (start instanceof ScriptableWithFallbackGetter) {
                    return ((ScriptableWithFallbackGetter)start).getWithFallback(name);
                }
                return NOT_FOUND;
            }

            public String getClassName() {
                return "htmlUnitHelper-fallbackCaller";
            }
        };
        ScriptableObject.getObjectPrototype((Scriptable)window).setPrototype((Scriptable)fallbackCaller);
        for (String jsClassName : jsConfig.keySet()) {
            ClassConfiguration config = jsConfig.getClassConfiguration(jsClassName);
            boolean isWindow = Window.class.getName().equals(config.getLinkedClass().getName());
            if (isWindow) {
                this.configureConstantsPropertiesAndFunctions(config, window);
                continue;
            }
            Scriptable prototype = this.configureClass(config, window);
            if (config.isJsObject()) {
                if (!this.getWebClient().getBrowserVersion().isIE()) {
                    SimpleScriptable obj = config.getLinkedClass().newInstance();
                    obj.put("prototype", (Scriptable)obj, prototype);
                    obj.setParentScope(window);
                    ScriptableObject.defineProperty((Scriptable)window, (String)config.getClassName(), (Object)((Object)obj), (int)2);
                    this.configureConstants(config, obj);
                    if (((Object)((Object)obj)).getClass() == Element.class && webWindow.getEnclosedPage() instanceof HtmlPage) {
                        HtmlElement domNode = new HtmlElement(null, "", (SgmlPage)webWindow.getEnclosedPage(), null){
                            private static final long serialVersionUID = -5614158965497997095L;
                        };
                        obj.setDomNode(domNode);
                    }
                }
                prototypes.put(config.getLinkedClass(), prototype);
            }
            prototypesPerJSName.put(config.getClassName(), prototype);
        }
        Scriptable objectPrototype = ScriptableObject.getObjectPrototype((Scriptable)window);
        for (Map.Entry entry : prototypesPerJSName.entrySet()) {
            String name = (String)entry.getKey();
            ClassConfiguration config = jsConfig.getClassConfiguration(name);
            Scriptable prototype = (Scriptable)entry.getValue();
            if (prototype.getPrototype() != null) {
                prototype = prototype.getPrototype();
            }
            if (!StringUtils.isEmpty((String)config.getExtendedClass())) {
                Scriptable parentPrototype = (Scriptable)prototypesPerJSName.get(config.getExtendedClass());
                prototype.setPrototype(parentPrototype);
                continue;
            }
            prototype.setPrototype(objectPrototype);
        }
        Class[] evalFnTypes = new Class[]{String.class};
        Method evalFn = Window.class.getMethod("custom_eval", evalFnTypes);
        FunctionObject jsCustomEval = new FunctionObject("eval", (Member)evalFn, (Scriptable)window);
        window.associateValue("custom_eval", jsCustomEval);
        for (String jsClassName : jsConfig.keySet()) {
            Scriptable prototype;
            ClassConfiguration config = jsConfig.getClassConfiguration(jsClassName);
            Method jsConstructor = config.getJsConstructor();
            if (jsConstructor == null || (prototype = (Scriptable)prototypesPerJSName.get(jsClassName)) == null) continue;
            FunctionObject jsCtor = new FunctionObject(jsClassName, (Member)jsConstructor, (Scriptable)window);
            jsCtor.addAsConstructor((Scriptable)window, prototype);
        }
        window.setPrototypes(prototypes);
        window.initialize(webWindow);
    }

    private Scriptable configureClass(ClassConfiguration config, Scriptable window) throws InstantiationException, IllegalAccessException {
        Class<? extends SimpleScriptable> jsHostClass = config.getLinkedClass();
        ScriptableObject prototype = jsHostClass.newInstance();
        prototype.setParentScope(window);
        this.configureConstantsPropertiesAndFunctions(config, prototype);
        return prototype;
    }

    private void configureConstantsPropertiesAndFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        this.configureConstants(config, scriptable);
        for (String entryKey : config.propertyKeys()) {
            Method readMethod = config.getPropertyReadMethod(entryKey);
            Method writeMethod = config.getPropertyWriteMethod(entryKey);
            scriptable.defineProperty(entryKey, null, readMethod, writeMethod, 0);
        }
        for (String entryKey : config.functionKeys()) {
            Method method = config.getFunctionMethod(entryKey);
            FunctionObject functionObject = new FunctionObject(entryKey, (Member)method, (Scriptable)scriptable);
            scriptable.defineProperty(entryKey, (Object)functionObject, 0);
        }
    }

    private void configureConstants(ClassConfiguration config, ScriptableObject scriptable) {
        for (String constant : config.constants()) {
            Class<? extends SimpleScriptable> linkedClass = config.getLinkedClass();
            try {
                Object value = linkedClass.getField(constant).get(null);
                scriptable.defineProperty(constant, value, 0);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("Cannot get field '" + constant + "' for type: " + config.getClassName()));
            }
        }
    }

    protected Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public Script compile(HtmlPage htmlPage, String sourceCode, final String sourceName, final int startLine) {
        String sourceCodeTrimmed;
        WebAssert.notNull("sourceCode", sourceCode);
        sourceCode = this.preProcess(htmlPage, sourceCode, sourceName, null);
        BrowserVersion browserVersion = htmlPage.getWebClient().getBrowserVersion();
        if (browserVersion.isIE() && browserVersion.getBrowserVersionNumeric() >= 4.0f) {
            IEConditionalCompilationScriptPreProcessor ieCCPreProcessor = new IEConditionalCompilationScriptPreProcessor();
            sourceCode = ieCCPreProcessor.preProcess(htmlPage, sourceCode, sourceName, null);
        }
        if ((sourceCodeTrimmed = sourceCode.trim()).startsWith("<!--")) {
            sourceCode = sourceCode.replaceFirst("<!--", "// <!--");
        }
        if (this.getWebClient().getBrowserVersion().isIE() && sourceCodeTrimmed.endsWith("-->")) {
            int lastDoubleSlash = sourceCode.lastIndexOf("//");
            int lastNewLine = Math.max(sourceCode.lastIndexOf(10), sourceCode.lastIndexOf(13));
            if (lastNewLine > lastDoubleSlash) {
                sourceCode = sourceCode.substring(0, lastNewLine);
            }
        }
        Scriptable scope = this.getScope(htmlPage, null);
        final String source = sourceCode;
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            public Object doRun(Context cx) {
                return cx.compileString(source, sourceName, startLine, null);
            }

            protected String getSourceCode(Context cx) {
                return source;
            }
        };
        return (Script)this.getContextFactory().call(action);
    }

    public Object execute(HtmlPage htmlPage, String sourceCode, String sourceName, int startLine) {
        Script script = this.compile(htmlPage, sourceCode, sourceName, startLine);
        return this.execute(htmlPage, script);
    }

    public Object execute(HtmlPage htmlPage, final Script script) {
        final Scriptable scope = this.getScope(htmlPage, null);
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            public Object doRun(Context cx) {
                return script.exec(cx, scope);
            }

            protected String getSourceCode(Context cx) {
                return null;
            }
        };
        return this.getContextFactory().call(action);
    }

    public Object callFunction(final HtmlPage htmlPage, Object javaScriptFunction, final Object thisObject, final Object[] args, DomNode htmlElement) {
        final Scriptable scope = this.getScope(htmlPage, htmlElement);
        final Function function = (Function)javaScriptFunction;
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            public Object doRun(Context cx) {
                return JavaScriptEngine.this.callFunction(htmlPage, function, cx, scope, (Scriptable)thisObject, args);
            }

            protected String getSourceCode(Context cx) {
                return cx.decompileFunction(function, 2);
            }
        };
        return this.getContextFactory().call(action);
    }

    private Scriptable getScope(HtmlPage htmlPage, DomNode htmlElement) {
        Object scope = htmlElement != null ? htmlElement.getScriptObject() : (Window)htmlPage.getEnclosingWindow().getScriptObject();
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(HtmlPage htmlPage, Function function, Context context, Scriptable scope, Scriptable thisObject, Object[] args) {
        HtmlPage htmlPage2 = htmlPage;
        synchronized (htmlPage2) {
            Object result = function.call(context, scope, thisObject, args);
            this.processPostponedActions();
            return result;
        }
    }

    public boolean isScriptRunning() {
        return Boolean.TRUE.equals(javaScriptRunning_.get());
    }

    private void processPostponedActions() {
        List<PostponedAction> actions = postponedActions_.get();
        postponedActions_.set(null);
        if (actions != null) {
            try {
                for (PostponedAction action : actions) {
                    action.execute();
                }
            }
            catch (Exception e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
    }

    public static Log getScriptEngineLog() {
        return ScriptEngineLog_;
    }

    public String preProcess(HtmlPage htmlPage, String sourceCode, String sourceName, HtmlElement htmlElement) {
        String newSourceCode = sourceCode;
        ScriptPreProcessor preProcessor = this.getWebClient().getScriptPreProcessor();
        if (preProcessor != null && (newSourceCode = preProcessor.preProcess(htmlPage, sourceCode, sourceName, htmlElement)) == null) {
            newSourceCode = "";
        }
        return newSourceCode;
    }

    public void addPostponedAction(PostponedAction action) {
        List<PostponedAction> actions = postponedActions_.get();
        if (actions == null) {
            actions = new ArrayList<PostponedAction>();
            postponedActions_.set(actions);
        }
        actions.add(action);
    }

    protected void reportJavaScriptException(ScriptException scriptException) {
        if (this.getWebClient().isThrowExceptionOnScriptError()) {
            throw scriptException;
        }
        this.getLog().info((Object)"Caught script exception", (Throwable)scriptException);
    }

    private abstract class HtmlUnitContextAction
    implements ContextAction {
        private final Scriptable scope_;
        private final HtmlPage htmlPage_;

        public HtmlUnitContextAction(Scriptable scope, HtmlPage htmlPage) {
            this.scope_ = scope;
            this.htmlPage_ = htmlPage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object run(Context cx) {
            Boolean javaScriptAlreadyRunning = (Boolean)javaScriptRunning_.get();
            javaScriptRunning_.set(Boolean.TRUE);
            try {
                cx.putThreadLocal((Object)JavaScriptEngine.KEY_STARTING_SCOPE, (Object)this.scope_);
                HtmlPage htmlPage = this.htmlPage_;
                synchronized (htmlPage) {
                    try {
                        Object response = this.doRun(cx);
                        JavaScriptEngine.this.processPostponedActions();
                        Object object = response;
                        return object;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (Exception e) {
                            JavaScriptEngine.this.reportJavaScriptException(new ScriptException(this.htmlPage_, e, this.getSourceCode(cx)));
                            Object var4_7 = null;
                            return var4_7;
                        }
                        catch (TimeoutError e) {
                            if (JavaScriptEngine.this.getWebClient().isThrowExceptionOnScriptError()) {
                                throw new RuntimeException(e);
                            }
                            JavaScriptEngine.this.getLog().info((Object)"Caught script timeout error", (Throwable)e);
                            Object var4_8 = null;
                            return var4_8;
                        }
                    }
                }
            }
            finally {
                javaScriptRunning_.set(javaScriptAlreadyRunning);
            }
        }

        protected abstract Object doRun(Context var1);

        protected abstract String getSourceCode(Context var1);
    }
}

