/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventListenersContainer;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.w3c.dom.Document;

public class Node
extends SimpleScriptable {
    private static final long serialVersionUID = -5695262053081637445L;
    private HTMLCollection childNodes_;
    private EventListenersContainer eventListenersContainer_;
    public static final short ELEMENT_NODE = 1;
    public static final short ATTRIBUTE_NODE = 2;
    public static final short TEXT_NODE = 3;
    public static final short CDATA_SECTION_NODE = 4;
    public static final short ENTITY_REFERENCE_NODE = 5;
    public static final short ENTITY_NODE = 6;
    public static final short PROCESSING_INSTRUCTION_NODE = 7;
    public static final short COMMENT_NODE = 8;
    public static final short DOCUMENT_NODE = 9;
    public static final short DOCUMENT_TYPE_NODE = 10;
    public static final short DOCUMENT_FRAGMENT_NODE = 11;
    public static final short NOTATION_NODE = 12;
    public static final short DOCUMENT_POSITION_DISCONNECTED = 1;
    public static final short DOCUMENT_POSITION_PRECEDING = 2;
    public static final short DOCUMENT_POSITION_FOLLOWING = 4;
    public static final short DOCUMENT_POSITION_CONTAINS = 8;
    public static final short DOCUMENT_POSITION_CONTAINED_BY = 16;
    public static final short DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;

    public short jsxGet_nodeType() {
        return this.getDomNodeOrDie().getNodeType();
    }

    public String jsxGet_nodeName() {
        return this.getDomNodeOrDie().getNodeName();
    }

    public String jsxGet_nodeValue() {
        return this.getDomNodeOrDie().getNodeValue();
    }

    public void jsxSet_nodeValue(String newValue) {
        this.getDomNodeOrDie().setNodeValue(newValue);
    }

    public Object jsxFunction_appendChild(Object childObject) {
        Object appendedChild = null;
        if (childObject instanceof Node) {
            DomNode childDomNode = ((Node)((Object)childObject)).getDomNodeOrDie();
            DomNode parentNode = this.getDomNodeOrDie();
            parentNode.appendChild(childDomNode);
            appendedChild = childObject;
            if (!(parentNode instanceof SgmlPage) && !(this instanceof DocumentFragment) && parentNode.getParentNode() == null && this.getBrowserVersion().isIE()) {
                DomDocumentFragment fragment = parentNode.getPage().createDomDocumentFragment();
                fragment.appendChild(parentNode);
            }
        }
        return appendedChild;
    }

    public Object jsxFunction_cloneNode(boolean deep) {
        DomNode domNode = this.getDomNodeOrDie();
        DomNode clonedNode = domNode.cloneNode(deep);
        Node jsClonedNode = (Node)((Object)this.getJavaScriptNode(clonedNode));
        if (this.getBrowserVersion().isIE()) {
            this.copyEventListenersWhenNeeded(domNode, clonedNode);
        }
        return jsClonedNode;
    }

    private void copyEventListenersWhenNeeded(DomNode domNode, DomNode clonedNode) {
        Node jsNode = (Node)domNode.getScriptObject();
        if (jsNode != null) {
            Node jsClonedNode = (Node)((Object)this.getJavaScriptNode(clonedNode));
            jsClonedNode.getEventListenersContainer().copyFrom(jsNode.getEventListenersContainer());
        }
        DomNode child = domNode.getFirstChild();
        for (DomNode clonedChild = clonedNode.getFirstChild(); child != null && clonedChild != null; child = child.getNextSibling(), clonedChild = clonedChild.getNextSibling()) {
            this.copyEventListenersWhenNeeded(child, clonedChild);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object jsxFunction_insertBefore(Object newChildObject, Object refChildObject) {
        DomNode refChildNode;
        Object appendedChild = null;
        if (!(newChildObject instanceof Node)) return appendedChild;
        DomNode newChildNode = ((Node)((Object)newChildObject)).getDomNodeOrDie();
        if (newChildNode instanceof DomDocumentFragment) {
            DomDocumentFragment fragment = (DomDocumentFragment)newChildNode;
            for (DomNode child : fragment.getChildren()) {
                this.jsxFunction_insertBefore(child.getScriptObject(), refChildObject);
            }
            return newChildObject;
        }
        if (Context.getUndefinedValue().equals(refChildObject)) {
            if (!this.getBrowserVersion().isIE()) throw Context.reportRuntimeError((String)"insertBefore: not enough arguments");
            refChildNode = null;
        } else {
            refChildNode = refChildObject != null ? ((Node)((Object)refChildObject)).getDomNodeOrDie() : null;
        }
        if (refChildNode != null) {
            refChildNode.insertBefore(newChildNode);
            appendedChild = newChildObject;
        } else {
            this.getDomNodeOrDie().appendChild(newChildNode);
        }
        if (this.getDomNodeOrDie().getParentNode() != null || !this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE()) return appendedChild;
        DomDocumentFragment fragment = ((HtmlPage)this.getDomNodeOrDie().getPage()).createDomDocumentFragment();
        fragment.appendChild(this.getDomNodeOrDie());
        return appendedChild;
    }

    public boolean jsxFunction_isSameNode(Object other) {
        return other == this;
    }

    public Object jsxFunction_removeChild(Object childObject) {
        Object removedChild = null;
        if (childObject instanceof Node) {
            DomNode childNode = ((Node)((Object)childObject)).getDomNodeOrDie();
            childNode.remove();
            removedChild = childObject;
        }
        return removedChild;
    }

    public boolean jsxFunction_hasChildNodes() {
        return this.getDomNodeOrDie().getChildren().iterator().hasNext();
    }

    public Object jsxGet_childNodes() {
        if (this.childNodes_ == null) {
            this.childNodes_ = new HTMLCollection(this);
            this.childNodes_.initFromChildren(this.getDomNodeOrDie());
        }
        return this.childNodes_;
    }

    public Object jsxFunction_replaceChild(Object newChildObject, Object oldChildObject) {
        Object removedChild = null;
        if (newChildObject instanceof DocumentFragment) {
            DocumentFragment fragment = (DocumentFragment)((Object)newChildObject);
            Node firstNode = null;
            Node refChildObject = (Node)((Object)((Node)((Object)oldChildObject)).jsxGet_nextSibling());
            for (DomNode node : fragment.getDomNodeOrDie().getChildren()) {
                if (firstNode == null) {
                    this.jsxFunction_replaceChild(node.getScriptObject(), oldChildObject);
                    firstNode = (Node)node.getScriptObject();
                    continue;
                }
                this.jsxFunction_insertBefore(node.getScriptObject(), (Object)refChildObject);
            }
            if (firstNode == null) {
                this.jsxFunction_removeChild(oldChildObject);
            }
            removedChild = oldChildObject;
        } else if (newChildObject instanceof Node && oldChildObject instanceof Node) {
            DomNode newChildNode = ((Node)((Object)newChildObject)).getDomNodeOrDie();
            DomNode oldChildNode = ((Node)((Object)oldChildObject)).getDomNodeOrDie();
            oldChildNode.replace(newChildNode);
            removedChild = oldChildObject;
        }
        return removedChild;
    }

    public Object jsxGet_parentNode() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getParentNode());
    }

    public Object jsxGet_nextSibling() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getNextSibling());
    }

    public Object jsxGet_previousSibling() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getPreviousSibling());
    }

    public Object jsxGet_firstChild() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getFirstChild());
    }

    public Object jsxGet_lastChild() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getLastChild());
    }

    protected Object getJavaScriptNode(DomNode domNode) {
        if (domNode == null) {
            return null;
        }
        return this.getScriptableFor(domNode);
    }

    public boolean jsxFunction_attachEvent(String type, Function listener) {
        return this.getEventListenersContainer().addEventListener(StringUtils.substring((String)type, (int)2), listener, false);
    }

    public void jsxFunction_addEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().addEventListener(type, listener, useCapture);
    }

    private EventListenersContainer getEventListenersContainer() {
        if (this.eventListenersContainer_ == null) {
            this.eventListenersContainer_ = new EventListenersContainer(this);
        }
        return this.eventListenersContainer_;
    }

    public void jsxFunction_detachEvent(String type, Function listener) {
        this.jsxFunction_removeEventListener(StringUtils.substring((String)type, (int)2), listener, false);
    }

    public void jsxFunction_removeEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().removeEventListener(type, listener, useCapture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult executeEvent(Event event) {
        if (this.eventListenersContainer_ != null) {
            HtmlPage page = (HtmlPage)this.getDomNodeOrDie().getPage();
            boolean isIE = this.getBrowserVersion().isIE();
            Window window = (Window)page.getEnclosingWindow().getScriptObject();
            Object[] args = new Object[]{event};
            if (isIE) {
                window.setEvent((Object)event);
            }
            Object[] propHandlerArgs = isIE ? ArrayUtils.EMPTY_OBJECT_ARRAY : args;
            try {
                ScriptResult scriptResult = this.eventListenersContainer_.executeListeners(event, args, propHandlerArgs);
                return scriptResult;
            }
            finally {
                window.setEvent(null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult fireEvent(Event event) {
        HtmlPage page = (HtmlPage)this.getDomNodeOrDie().getPage();
        boolean ie = this.getBrowserVersion().isIE();
        Window window = (Window)page.getEnclosingWindow().getScriptObject();
        Object[] args = new Object[]{event};
        event.startFire();
        ScriptResult result = null;
        Object previousEvent = window.jsxGet_event();
        if (ie) {
            window.setEvent((Object)event);
        }
        try {
            DomNode node;
            EventListenersContainer windowsListeners = this.getWindow().getEventListenersContainer();
            event.setEventPhase((short)1);
            result = windowsListeners.executeCapturingListeners(event, args);
            if (event.isPropagationStopped()) {
                ScriptResult scriptResult = result;
                return scriptResult;
            }
            ArrayList<DomNode> parents = new ArrayList<DomNode>();
            for (node = this.getDomNodeOrDie(); node != null; node = node.getParentNode()) {
                parents.add(node);
            }
            for (int i = parents.size() - 1; i >= 0; --i) {
                DomNode curNode = (DomNode)parents.get(i);
                Node jsNode = (Node)curNode.getScriptObject();
                EventListenersContainer elc = jsNode.eventListenersContainer_;
                if (elc == null) continue;
                ScriptResult r = elc.executeCapturingListeners(event, args);
                result = ScriptResult.combine(r, result, ie);
                if (!event.isPropagationStopped()) continue;
                ScriptResult scriptResult = result;
                return scriptResult;
            }
            Object[] propHandlerArgs = ie ? ArrayUtils.EMPTY_OBJECT_ARRAY : args;
            event.setEventPhase((short)2);
            for (node = this.getDomNodeOrDie(); node != null; node = node.getParentNode()) {
                Node jsNode = (Node)node.getScriptObject();
                EventListenersContainer elc = jsNode.eventListenersContainer_;
                if (elc != null) {
                    ScriptResult r = elc.executeBubblingListeners(event, args, propHandlerArgs);
                    result = ScriptResult.combine(r, result, ie);
                    if (event.isPropagationStopped()) {
                        ScriptResult scriptResult = result;
                        return scriptResult;
                    }
                }
                event.setEventPhase((short)3);
            }
            ScriptResult r = windowsListeners.executeBubblingListeners(event, args, propHandlerArgs);
            result = ScriptResult.combine(r, result, ie);
        }
        finally {
            event.endFire();
            window.setEvent(previousEvent);
        }
        return result;
    }

    public Function getEventHandler(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return null;
        }
        return this.eventListenersContainer_.getEventHandler(StringUtils.substring((String)eventName, (int)2));
    }

    public void setEventHandler(String eventName, Function eventHandler) {
        this.setEventHandlerProp(eventName, eventHandler);
    }

    protected void setEventHandlerProp(String eventName, Object value) {
        this.getEventListenersContainer().setEventHandlerProp(StringUtils.substring((String)eventName.toLowerCase(), (int)2), value);
    }

    protected Object getEventHandlerProp(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return null;
        }
        return this.eventListenersContainer_.getEventHandlerProp(StringUtils.substring((String)eventName.toLowerCase(), (int)2));
    }

    public Object jsxGet_ownerDocument() {
        Document document = this.getDomNodeOrDie().getOwnerDocument();
        if (document == null) {
            return null;
        }
        return ((SgmlPage)((Object)document)).getScriptObject();
    }

    public Object jsxGet_prefix() {
        if (this.getBrowserVersion().isIE()) {
            if (this.getDomNodeOrDie().getPage() instanceof HtmlPage) {
                return NOT_FOUND;
            }
            return "";
        }
        return this.getDomNodeOrDie().getPrefix();
    }

    public Object jsxGet_localName() {
        if (this.getBrowserVersion().isIE()) {
            return NOT_FOUND;
        }
        return this.getDomNodeOrDie().getLocalName();
    }

    public Object jsxGet_namespaceURI() {
        if (this.getBrowserVersion().isIE()) {
            if (this.getDomNodeOrDie().getPage() instanceof HtmlPage) {
                return NOT_FOUND;
            }
            return "";
        }
        return this.getDomNodeOrDie().getNamespaceURI();
    }

    public short jsxFunction_compareDocumentPosition(HTMLElement element) {
        return this.getDomNodeOrDie().compareDocumentPosition(element.getDomNodeOrDie());
    }
}

