/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class By {
    public static By id(final String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot find elements with a null id attribute.");
        }
        return new By(){

            @Override
            public List<WebElement> findElements(SearchContext context) {
                if (context instanceof FindsById) {
                    return ((FindsById)((Object)context)).findElementsById(id);
                }
                return ((FindsByXPath)((Object)context)).findElementsByXPath("*[@id = '" + id + "']");
            }

            @Override
            public WebElement findElement(SearchContext context) {
                if (context instanceof FindsById) {
                    return ((FindsById)((Object)context)).findElementById(id);
                }
                return ((FindsByXPath)((Object)context)).findElementByXPath("*[@id = '" + id + "']");
            }

            public String toString() {
                return "By.id: " + id;
            }
        };
    }

    public static By linkText(final String linkText) {
        if (linkText == null) {
            throw new IllegalArgumentException("Cannot find elements when link text is null.");
        }
        return new By(){

            @Override
            public List<WebElement> findElements(SearchContext context) {
                return ((FindsByLinkText)((Object)context)).findElementsByLinkText(linkText);
            }

            @Override
            public WebElement findElement(SearchContext context) {
                return ((FindsByLinkText)((Object)context)).findElementByLinkText(linkText);
            }

            public String toString() {
                return "By.linkText: " + linkText;
            }
        };
    }

    public static By partialLinkText(final String linkText) {
        if (linkText == null) {
            throw new IllegalArgumentException("Cannot find elements when link text is null.");
        }
        return new By(){

            @Override
            public List<WebElement> findElements(SearchContext context) {
                return ((FindsByLinkText)((Object)context)).findElementsByPartialLinkText(linkText);
            }

            @Override
            public WebElement findElement(SearchContext context) {
                return ((FindsByLinkText)((Object)context)).findElementByPartialLinkText(linkText);
            }

            public String toString() {
                return "By.linkText: " + linkText;
            }
        };
    }

    public static By name(final String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot find elements when name text is null.");
        }
        return new By(){

            @Override
            public List<WebElement> findElements(SearchContext context) {
                if (context instanceof FindsByName) {
                    return ((FindsByName)((Object)context)).findElementsByName(name);
                }
                return ((FindsByXPath)((Object)context)).findElementsByXPath(".//*[@name = '" + name + "']");
            }

            @Override
            public WebElement findElement(SearchContext context) {
                if (context instanceof FindsByName) {
                    return ((FindsByName)((Object)context)).findElementByName(name);
                }
                return ((FindsByXPath)((Object)context)).findElementByXPath(".//*[@name = '" + name + "']");
            }

            public String toString() {
                return "By.name: " + name;
            }
        };
    }

    public static By tagName(final String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot find elements when name tag name is null.");
        }
        return new By(){

            @Override
            public List<WebElement> findElements(SearchContext context) {
                if (context instanceof FindsByTagName) {
                    return ((FindsByTagName)((Object)context)).findElementsByTagName(name);
                }
                return ((FindsByXPath)((Object)context)).findElementsByXPath(".//" + name);
            }

            @Override
            public WebElement findElement(SearchContext context) {
                if (context instanceof FindsByTagName) {
                    return ((FindsByTagName)((Object)context)).findElementByTagName(name);
                }
                return ((FindsByXPath)((Object)context)).findElementByXPath(".//" + name);
            }

            public String toString() {
                return "By.tagName: " + name;
            }
        };
    }

    public static By xpath(final String xpathExpression) {
        if (xpathExpression == null) {
            throw new IllegalArgumentException("Cannot find elements when the XPath expression is null.");
        }
        return new By(){

            @Override
            public List<WebElement> findElements(SearchContext context) {
                return ((FindsByXPath)((Object)context)).findElementsByXPath(xpathExpression);
            }

            @Override
            public WebElement findElement(SearchContext context) {
                return ((FindsByXPath)((Object)context)).findElementByXPath(xpathExpression);
            }

            public String toString() {
                return "By.xpath: " + xpathExpression;
            }
        };
    }

    public static By className(final String className) {
        if (className == null) {
            throw new IllegalArgumentException("Cannot find elements when the class name expression is null.");
        }
        return new By(){

            @Override
            public List<WebElement> findElements(SearchContext context) {
                if (context instanceof FindsByClassName) {
                    return ((FindsByClassName)((Object)context)).findElementsByClassName(className);
                }
                return ((FindsByXPath)((Object)context)).findElementsByXPath(".//*[" + this.containingWord("class", className) + "]");
            }

            @Override
            public WebElement findElement(SearchContext context) {
                if (context instanceof FindsByClassName) {
                    return ((FindsByClassName)((Object)context)).findElementByClassName(className);
                }
                return ((FindsByXPath)((Object)context)).findElementByXPath(".//*[" + this.containingWord("class", className) + "]");
            }

            private String containingWord(String attribute, String word) {
                return "contains(concat(' ',normalize-space(@" + attribute + "),' '),' " + word + " ')";
            }

            public String toString() {
                return "By.className: " + className;
            }
        };
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> allElements = this.findElements(context);
        if (allElements == null || allElements.size() == 0) {
            throw new NoSuchElementException("Cannot locate an element using " + this.toString());
        }
        return allElements.get(0);
    }

    public abstract List<WebElement> findElements(SearchContext var1);

    public List<WebElement> findElements(WebDriver driver) {
        return this.findElements((SearchContext)((Object)driver));
    }

    public WebElement findElement(WebDriver driver) {
        return this.findElement((SearchContext)((Object)driver));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        By by = (By)o;
        return this.toString().equals(by.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

