/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue.dev;

import com.google.appengine.api.labs.taskqueue.QueueConstants;
import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.api.labs.taskqueue.dev.DevQueue;
import com.google.appengine.api.labs.taskqueue.dev.QueueStateInfo;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.QueueXml;
import com.google.apphosting.utils.config.QueueXmlReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public class LocalTaskQueue
implements LocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalTaskQueue.class.getName());
    public static final String SERVICE_NAME = "taskqueue";
    private Map<String, DevQueue> queues = Collections.synchronizedMap(new HashMap());
    private Thread shutdownHook;
    private QueueXml queueXml;
    private final AtomicInteger taskNameGenerator = new AtomicInteger(0);

    public void init(LocalServiceContext context, Map<String, String> properties) {
        QueueXmlReader reader = new QueueXmlReader(context.getAppDir().getPath());
        this.queueXml = reader.readQueueXml();
        logger.log(Level.INFO, "LocalTaskQueue is initialized");
    }

    void setQueueXml(QueueXml queueXml) {
        this.queueXml = queueXml;
    }

    public void start() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LocalTaskQueue.this.start_();
                return null;
            }
        });
    }

    private void start_() {
        this.shutdownHook = new Thread(){

            public void run() {
                LocalTaskQueue.this.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        if (this.queueXml != null) {
            for (QueueXml.Entry entry : this.queueXml.getEntries()) {
                this.queues.put(entry.getName(), new DevQueue(entry, this.taskNameGenerator));
            }
        }
        if (this.queues.get("default") == null) {
            QueueXml.Entry entry = QueueXml.defaultEntry();
            this.queues.put(entry.getName(), new DevQueue(entry, this.taskNameGenerator));
        }
    }

    public void stop() {
        this.queues.clear();
    }

    public String getPackage() {
        return SERVICE_NAME;
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    private long currentTimeUsec() {
        return this.currentTimeMillis() * 1000L;
    }

    void validateAddRequest(TaskQueuePb.TaskQueueAddRequest addRequest) {
        String taskName = addRequest.getTaskName();
        if (taskName != null && taskName.length() != 0 && !QueueConstants.TASK_NAME_PATTERN.matcher(taskName).matches()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_TASK_NAME.getValue());
        }
        String queueName = addRequest.getQueueName();
        if (queueName == null || queueName.length() == 0 || !QueueConstants.QUEUE_NAME_PATTERN.matcher(queueName).matches()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_QUEUE_NAME.getValue());
        }
        String url = addRequest.getUrl();
        if (!addRequest.hasUrl() || url.length() == 0 || url.charAt(0) != '/' || url.length() > QueueConstants.maxUrlLength()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_URL.getValue());
        }
        if (addRequest.getEtaUsec() < 0L) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_ETA.getValue());
        }
        if (addRequest.getEtaUsec() - this.currentTimeUsec() > QueueConstants.getMaxEtaDeltaMillis()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_ETA.getValue());
        }
    }

    public TaskQueuePb.TaskQueueAddResponse add(LocalRpcService.Status status, TaskQueuePb.TaskQueueAddRequest addRequest) {
        this.validateAddRequest(addRequest);
        DevQueue queue = this.getQueueByName(addRequest.getQueueName());
        return queue.add(addRequest);
    }

    public Map<String, QueueStateInfo> getQueueStateInfo() {
        TreeMap<String, QueueStateInfo> queueStateInfo = new TreeMap<String, QueueStateInfo>();
        for (Map.Entry<String, DevQueue> entry : this.queues.entrySet()) {
            String queueName = entry.getKey();
            queueStateInfo.put(queueName, entry.getValue().getStateInfo());
        }
        return queueStateInfo;
    }

    private DevQueue getQueueByName(String queueName) {
        DevQueue queue = this.queues.get(queueName);
        if (queue == null) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.UNKNOWN_QUEUE.getValue());
        }
        return queue;
    }

    public void flushQueue(String queueName) {
        DevQueue queue = this.getQueueByName(queueName);
        QueueXml.Entry entry = queue.getEntry();
        DevQueue devQueue = new DevQueue(entry, this.taskNameGenerator);
        this.queues.put(queueName, devQueue);
    }

    public boolean deleteTask(String queueName, String taskName) {
        DevQueue queue = this.getQueueByName(queueName);
        return queue.deleteTask(taskName);
    }
}

