/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509TrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.contrib.ssl.AuthSSLInitializationError;
import org.apache.commons.httpclient.contrib.ssl.AuthSSLX509TrustManager;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(AuthSSLProtocolSocketFactory.class);
    private URL keystoreUrl = null;
    private String keystorePassword = null;
    private URL truststoreUrl = null;
    private String truststorePassword = null;
    private SSLContext sslcontext = null;

    public AuthSSLProtocolSocketFactory(URL uRL, String string, URL uRL2, String string2) {
        this.keystoreUrl = uRL;
        this.keystorePassword = string;
        this.truststoreUrl = uRL2;
        this.truststorePassword = string2;
    }

    private static KeyStore createKeyStore(URL uRL, String string) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Keystore url may not be null");
        }
        LOG.debug("Initializing key store");
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(uRL.openStream(), string != null ? string.toCharArray() : null);
        return keyStore;
    }

    private static KeyManager[] createKeyManagers(KeyStore keyStore, String string) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyStore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        LOG.debug("Initializing key manager");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, string != null ? string.toCharArray() : null);
        return keyManagerFactory.getKeyManagers();
    }

    private static TrustManager[] createTrustManagers(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        if (keyStore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        LOG.debug("Initializing trust manager");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        for (int i = 0; i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
            trustManagerArray[i] = new AuthSSLX509TrustManager((X509TrustManager)trustManagerArray[i]);
        }
        return trustManagerArray;
    }

    private SSLContext createSSLContext() {
        try {
            Object object;
            String string;
            Enumeration<String> enumeration;
            KeyStore keyStore;
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            if (this.keystoreUrl != null) {
                keyStore = AuthSSLProtocolSocketFactory.createKeyStore(this.keystoreUrl, this.keystorePassword);
                if (LOG.isDebugEnabled()) {
                    enumeration = keyStore.aliases();
                    while (enumeration.hasMoreElements()) {
                        string = enumeration.nextElement();
                        object = keyStore.getCertificateChain(string);
                        if (object == null) continue;
                        LOG.debug("Certificate chain '" + string + "':");
                        for (int i = 0; i < ((Certificate[])object).length; ++i) {
                            if (!(object[i] instanceof X509Certificate)) continue;
                            X509Certificate x509Certificate = (X509Certificate)object[i];
                            LOG.debug(" Certificate " + (i + 1) + ":");
                            LOG.debug("  Subject DN: " + x509Certificate.getSubjectDN());
                            LOG.debug("  Signature Algorithm: " + x509Certificate.getSigAlgName());
                            LOG.debug("  Valid from: " + x509Certificate.getNotBefore());
                            LOG.debug("  Valid until: " + x509Certificate.getNotAfter());
                            LOG.debug("  Issuer: " + x509Certificate.getIssuerDN());
                        }
                    }
                }
                keyManagerArray = AuthSSLProtocolSocketFactory.createKeyManagers(keyStore, this.keystorePassword);
            }
            if (this.truststoreUrl != null) {
                keyStore = AuthSSLProtocolSocketFactory.createKeyStore(this.truststoreUrl, this.truststorePassword);
                if (LOG.isDebugEnabled()) {
                    enumeration = keyStore.aliases();
                    while (enumeration.hasMoreElements()) {
                        string = enumeration.nextElement();
                        LOG.debug("Trusted certificate '" + string + "':");
                        object = keyStore.getCertificate(string);
                        if (object == null || !(object instanceof X509Certificate)) continue;
                        X509Certificate x509Certificate = (X509Certificate)object;
                        LOG.debug("  Subject DN: " + x509Certificate.getSubjectDN());
                        LOG.debug("  Signature Algorithm: " + x509Certificate.getSigAlgName());
                        LOG.debug("  Valid from: " + x509Certificate.getNotBefore());
                        LOG.debug("  Valid until: " + x509Certificate.getNotAfter());
                        LOG.debug("  Issuer: " + x509Certificate.getIssuerDN());
                    }
                }
                trustManagerArray = AuthSSLProtocolSocketFactory.createTrustManagers(keyStore);
            }
            keyStore = SSLContext.getInstance((String)"SSL");
            keyStore.init(keyManagerArray, trustManagerArray, null);
            return keyStore;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            throw new AuthSSLInitializationError("Unsupported algorithm exception: " + noSuchAlgorithmException.getMessage());
        }
        catch (KeyStoreException keyStoreException) {
            LOG.error(keyStoreException.getMessage(), keyStoreException);
            throw new AuthSSLInitializationError("Keystore exception: " + keyStoreException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOG.error(generalSecurityException.getMessage(), generalSecurityException);
            throw new AuthSSLInitializationError("Key management exception: " + generalSecurityException.getMessage());
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), iOException);
            throw new AuthSSLInitializationError("I/O error reading keystore/truststore file: " + iOException.getMessage());
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n3 = httpConnectionParams.getConnectionTimeout();
        if (n3 == 0) {
            return this.createSocket(string, n, inetAddress, n2);
        }
        return ControllerThreadSocketFactory.createSocket(this, string, n, inetAddress, n2, n3);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, string, n, bl);
    }
}

