/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLAnchorElement
extends HTMLElement {
    private static final long serialVersionUID = -816365374422492967L;

    public void jsConstructor() {
    }

    public void jsxSet_href(String href) {
        this.getHtmlElementOrDie().setAttribute("href", href);
    }

    public String jsxGet_href() {
        try {
            return this.getUrl().toString();
        }
        catch (MalformedURLException e) {
            return ((HtmlAnchor)this.getHtmlElementOrDie()).getHrefAttribute();
        }
    }

    public void jsxSet_name(String name) {
        this.getHtmlElementOrDie().setAttribute("name", name);
    }

    public String jsxGet_name() {
        return this.getHtmlElementOrDie().getAttribute("name");
    }

    public void jsxSet_target(String target) {
        this.getHtmlElementOrDie().setAttribute("target", target);
    }

    public String jsxGet_target() {
        return this.getHtmlElementOrDie().getAttribute("target");
    }

    private URL getUrl() throws MalformedURLException {
        HtmlAnchor anchor = (HtmlAnchor)this.getHtmlElementOrDie();
        return ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(anchor.getHrefAttribute());
    }

    private void setUrl(URL url) {
        this.getHtmlElementOrDie().setAttribute("href", url.toString());
    }

    public String jsxGet_search() throws Exception {
        String query = this.getUrl().getQuery();
        if (query == null) {
            return "";
        }
        return "?" + query;
    }

    public void jsxSet_search(String search) throws Exception {
        String query = search == null || "?".equals(search) || "".equals(search) ? null : (search.charAt(0) == '?' ? search.substring(1) : search);
        this.setUrl(UrlUtils.getUrlWithNewQuery(this.getUrl(), query));
    }

    public String jsxGet_hash() throws Exception {
        String hash = this.getUrl().getRef();
        if (hash == null) {
            return "";
        }
        return hash;
    }

    public void jsxSet_hash(String hash) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewRef(this.getUrl(), hash));
    }

    public String jsxGet_host() throws Exception {
        URL url = this.getUrl();
        int port = url.getPort();
        String host = url.getHost();
        if (port == -1) {
            return host;
        }
        return host + ":" + port;
    }

    public void jsxSet_host(String host) throws Exception {
        int port;
        String hostname;
        int index = host.indexOf(58);
        if (index != -1) {
            hostname = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            hostname = host;
            port = -1;
        }
        URL url1 = UrlUtils.getUrlWithNewHost(this.getUrl(), hostname);
        URL url2 = UrlUtils.getUrlWithNewPort(url1, port);
        this.setUrl(url2);
    }

    public String jsxGet_hostname() throws Exception {
        return this.getUrl().getHost();
    }

    public void jsxSet_hostname(String hostname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
    }

    public String jsxGet_pathname() throws Exception {
        return this.getUrl().getPath();
    }

    public void jsxSet_pathname(String pathname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPath(this.getUrl(), pathname));
    }

    public String jsxGet_port() throws Exception {
        int port = this.getUrl().getPort();
        if (port == -1) {
            return "";
        }
        return String.valueOf(port);
    }

    public void jsxSet_port(String port) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPort(this.getUrl(), Integer.parseInt(port)));
    }

    public String jsxGet_protocol() throws Exception {
        return this.getUrl().getProtocol() + ":";
    }

    public void jsxSet_protocol(String protocol) throws Exception {
        String bareProtocol = StringUtils.substringBefore((String)protocol, (String)":");
        this.setUrl(UrlUtils.getUrlWithNewProtocol(this.getUrl(), bareProtocol));
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        String response;
        HtmlAnchor link = (HtmlAnchor)this.getHtmlElementOrDie();
        String href = link.getHrefAttribute();
        if (href == HtmlElement.ATTRIBUTE_NOT_DEFINED) {
            response = "";
        } else {
            String anchorPart;
            String beforeAnchor;
            int indexAnchor = href.indexOf(35);
            if (indexAnchor == -1) {
                beforeAnchor = href;
                anchorPart = "";
            } else {
                beforeAnchor = href.substring(0, indexAnchor);
                anchorPart = href.substring(indexAnchor);
            }
            try {
                response = ((HtmlPage)link.getPage()).getFullyQualifiedUrl(beforeAnchor).toExternalForm() + anchorPart;
            }
            catch (MalformedURLException e) {
                return href;
            }
        }
        return response;
    }

    public void jsxFunction_click() throws IOException {
        ((ClickableElement)this.getHtmlElementOrDie()).click();
    }
}

