/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.jetty;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import java.io.IOException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;

class AppEngineAuthentication {
    private static final Logger log = Logger.getLogger(AppEngineAuthentication.class.getName());
    private static final String AUTH_URL_PREFIX = "/_ah/";
    private static final String AUTH_METHOD = "Google Login";
    private static final String AUTH_TYPE = "GOOGLE_AUTH";
    private static final String REALM_NAME = "Google App Engine";

    AppEngineAuthentication() {
    }

    public static void configureSecurityHandler(SecurityHandler handler) {
        handler.setAuthenticator(new AppEngineAuthenticator());
        handler.setUserRealm(new AppEngineUserRealm());
    }

    public static class AppEnginePrincipal
    implements Principal {
        private final User user;

        public AppEnginePrincipal(User user) {
            this.user = user;
        }

        public User getUser() {
            return this.user;
        }

        public String getName() {
            return this.user.getEmail();
        }

        public boolean equals(Object other) {
            if (other instanceof AppEnginePrincipal) {
                return this.user.equals((Object)((AppEnginePrincipal)other).user);
            }
            return false;
        }

        public String toString() {
            return this.user.toString();
        }

        public int hashCode() {
            return this.user.hashCode();
        }
    }

    private static class AppEngineUserRealm
    implements UserRealm {
        private static final String USER_ROLE = "*";
        private static final String ADMIN_ROLE = "admin";

        private AppEngineUserRealm() {
        }

        public boolean isUserInRole(Principal principal, String role) {
            UserService userService = UserServiceFactory.getUserService();
            log.info("Checking if principal " + principal + " is in role " + role);
            if (principal == null) {
                log.info("isUserInRole() called with null principal.");
                return false;
            }
            if (!(principal instanceof AppEnginePrincipal)) {
                log.info("Got an unexpected principal of type: " + principal.getClass().getName());
                return false;
            }
            User user = ((AppEnginePrincipal)principal).getUser();
            if (USER_ROLE.equals(role)) {
                return true;
            }
            if (ADMIN_ROLE.equals(role)) {
                if (user.equals((Object)userService.getCurrentUser())) {
                    return userService.isUserAdmin();
                }
                log.warning("Cannot tell if non-logged-in user " + user + " is an admin.");
                return false;
            }
            log.warning("Unknown role: " + role + ".");
            return false;
        }

        public String getName() {
            return AppEngineAuthentication.REALM_NAME;
        }

        public void disassociate(Principal user) {
            if (user != null) {
                log.fine("Ignoring disassociate call for: " + user);
            }
        }

        public Principal getPrincipal(String username) {
            log.info("getPrincipal(" + username + ") throwing UnsupportedOperationException.");
            throw new UnsupportedOperationException();
        }

        public Principal authenticate(String username, Object credentials, Request request) {
            log.info("Authenticate(" + username + ", " + credentials + ") " + "throwing UnsupportedOperationException.");
            throw new UnsupportedOperationException();
        }

        public boolean reauthenticate(Principal user) {
            log.info("reauthenticate(" + user + ") throwing UnsupportedOperationException.");
            throw new UnsupportedOperationException();
        }

        public Principal pushRole(Principal user, String role) {
            log.warning("pushRole throwing an UnsupportedOperationException");
            throw new UnsupportedOperationException();
        }

        public Principal popRole(Principal user) {
            log.warning("popRole throwing an UnsupportedOperationException");
            throw new UnsupportedOperationException();
        }

        public void logout(Principal user) {
            log.warning("logout(" + user + ") throwing an UnsupportedOperationException");
            throw new UnsupportedOperationException();
        }
    }

    private static class AppEngineAuthenticator
    implements Authenticator {
        private AppEngineAuthenticator() {
        }

        public Principal authenticate(UserRealm realm, String pathInContext, Request request, Response response) {
            UserService userService = UserServiceFactory.getUserService();
            if (request.getRequestURI().indexOf(AppEngineAuthentication.AUTH_URL_PREFIX) == 0) {
                log.fine("Got " + request.getRequestURI() + ", returning NOBODY to " + "imply authentication is in progress.");
                return SecurityHandler.__NOBODY;
            }
            if (userService.isUserLoggedIn()) {
                User user = userService.getCurrentUser();
                log.fine("authenticate() returning new principal for " + user);
                AppEnginePrincipal princple = new AppEnginePrincipal(user);
                request.setUserPrincipal(princple);
                request.setAuthType(AppEngineAuthentication.AUTH_TYPE);
                return princple;
            }
            if (response == null) {
                log.fine("Got " + request.getRequestURI() + " with null response, returning null.");
                return null;
            }
            log.info("Got " + request.getRequestURI() + " but no one was logged in, redirecting.");
            String url = userService.createLoginURL(request.getRequestURI());
            try {
                response.sendRedirect(url);
                return null;
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "Got an IOException from sendRedirect:", ex);
                return null;
            }
        }

        public String getAuthMethod() {
            return AppEngineAuthentication.AUTH_METHOD;
        }
    }
}

