/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.internal.Lock;

public class SocketLock
implements Lock {
    private static final long DELAY_BETWEEN_SOCKET_CHECKS = 100L;
    private final int lockPort;
    private final Socket lockSocket;

    public SocketLock(int lockPort) {
        this.lockPort = lockPort;
        this.lockSocket = new Socket();
    }

    public void lock(long time, TimeUnit unit) throws WebDriverException {
        InetSocketAddress address = new InetSocketAddress("localhost", this.lockPort);
        long maxWait = System.currentTimeMillis() + unit.toMillis(time);
        do {
            try {
                if (this.isLockFree(address)) {
                    return;
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new WebDriverException((Throwable)e);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        } while (System.currentTimeMillis() < maxWait);
        throw new WebDriverException(String.format("Unable to bind to locking port %d within %d %s", new Object[]{this.lockPort, time, unit}));
    }

    public void unlock() {
        try {
            if (this.lockSocket.isBound()) {
                this.lockSocket.close();
            }
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private boolean isLockFree(InetSocketAddress address) throws IOException {
        try {
            this.lockSocket.bind(address);
            return true;
        }
        catch (BindException e) {
            return false;
        }
    }
}

