/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.datanucleus.plugin.Bundle;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.store.appengine.jpa.DatastoreJPACallbackHandler;

final class DatastorePluginRegistry
implements PluginRegistry {
    private final PluginRegistry delegate;

    DatastorePluginRegistry(PluginRegistry delegate) {
        this.delegate = delegate;
    }

    public ExtensionPoint getExtensionPoint(String id) {
        ExtensionPoint ep = this.delegate.getExtensionPoint(id);
        if (id.equals("org.datanucleus.callbackhandler")) {
            boolean replaced = false;
            for (Extension ext : ep.getExtensions()) {
                for (ConfigurationElement cfg : ext.getConfigurationElements()) {
                    if (!cfg.getAttribute("name").equals("JPA")) continue;
                    cfg.putAttribute("class-name", DatastoreJPACallbackHandler.class.getName());
                    replaced = true;
                }
            }
            if (!replaced) {
                throw new RuntimeException("Unable to replace JPACallbackHandler.");
            }
        }
        return ep;
    }

    public ExtensionPoint[] getExtensionPoints() {
        return this.delegate.getExtensionPoints();
    }

    public void registerExtensionPoints() {
        this.delegate.registerExtensionPoints();
    }

    public void registerExtensions() {
        this.delegate.registerExtensions();
    }

    public Object createExecutableExtension(ConfigurationElement confElm, String name, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.delegate.createExecutableExtension(confElm, name, argsClass, args);
    }

    public Class loadClass(String pluginId, String className) throws ClassNotFoundException {
        return this.delegate.loadClass(pluginId, className);
    }

    public URL resolveURLAsFileURL(URL url) throws IOException {
        return this.delegate.resolveURLAsFileURL(url);
    }

    public void resolveConstraints() {
        this.delegate.resolveConstraints();
    }

    public Bundle[] getBundles() {
        return this.delegate.getBundles();
    }
}

