/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.adapter;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.t2framework.commons.bootstrap.CommonsInitializer;
import org.t2framework.commons.exception.NoSuchComponentException;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.BeanDescFactory;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.t2.adapter.AbstractContainerAdapter;
import org.t2framework.t2.handler.ExceptionHandler;
import org.t2framework.t2.handler.GlobalExceptionHandler;
import org.t2framework.t2.handler.impl.GlobalExceptionHandlerImpl;

public class GuiceAdapter
extends AbstractContainerAdapter<Injector> {
    protected static Logger logger = Logger.getLogger(GuiceAdapter.class);
    protected Injector injector;
    protected Module[] modules;

    public void init() {
        List moduleList = CollectionsUtil.newArrayList();
        Iterator iterator = CommonsInitializer.iterator((ServiceLoader)CommonsInitializer.load(Module.class));
        while (iterator.hasNext()) {
            moduleList.add(iterator.next());
        }
        this.modules = moduleList.toArray(new Module[0]);
    }

    public void init(String configPath) {
        this.init();
    }

    public <T> BeanDesc<T> getBeanDesc(Class<? super T> componentClass) {
        T component = this.getComponent(componentClass);
        return BeanDescFactory.getBeanDesc(component);
    }

    public <T> T getComponent(Class<? super T> componentClass) {
        Assertion.notNull(componentClass);
        this.setupInjector();
        try {
            return (T)this.injector.getInstance(componentClass);
        }
        catch (Throwable e) {
            throw new NoSuchComponentException(componentClass);
        }
    }

    protected void setupInjector() {
        if (this.injector == null) {
            this.injector = Guice.createInjector((Module[])this.modules);
        }
    }

    public <T> List<T> getComponents(Class<? super T> componentClass) {
        logger.debug("GuiceAdapter does not support getComponents(), so just return single component.");
        List ret = CollectionsUtil.newArrayList();
        ret.add(this.getComponent(componentClass));
        return ret;
    }

    public <T> boolean hasComponent(Class<T> componentClass) {
        try {
            return this.injector.getInstance(componentClass) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public <T> T injectDependency(T t) {
        this.injector.injectMembers(t);
        return t;
    }

    public <T> void register(Class<? extends T> key) {
        Assertion.notNull(key);
        logger.debug("GuiceAdapter can not register a component:" + key.getName());
    }

    public <T> void register(T key) {
        Assertion.notNull(key);
        logger.debug("GuiceAdapter can not register a component:" + key.getClass().getName());
    }

    public Injector getContainer() {
        return this.injector;
    }

    public List<ExceptionHandler<Throwable, Exception>> createExceptionHandlers() {
        logger.debug("GuiceAdapter does not support createrExceptionHandlers().");
        return CollectionsUtil.emptyList();
    }

    public GlobalExceptionHandler createGlobalExceptionHandler() {
        if (this.injector == null) {
            return new GlobalExceptionHandlerImpl();
        }
        GlobalExceptionHandler handler = (GlobalExceptionHandler)this.injector.getInstance(GlobalExceptionHandler.class);
        if (handler != null) {
            return handler;
        }
        return new GlobalExceptionHandlerImpl();
    }

    public void destroy() {
        this.injector = null;
    }

    protected synchronized void clearInjector() {
        if (this.injector != null) {
            this.injector = null;
        }
    }
}

