/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpParser {
    private static final Log LOG = LogFactory.getLog(HttpParser.class);

    private HttpParser() {
    }

    public static byte[] readRawLine(InputStream inputStream) throws IOException {
        int n;
        LOG.trace("enter HttpParser.readRawLine()");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream.write(n);
            if (n != 10) continue;
        }
        if (byteArrayOutputStream.size() == 0) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String readLine(InputStream inputStream, String string) throws IOException {
        LOG.trace("enter HttpParser.readLine(InputStream, String)");
        byte[] byArray = HttpParser.readRawLine(inputStream);
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        int n2 = 0;
        if (n > 0 && byArray[n - 1] == 10) {
            ++n2;
            if (n > 1 && byArray[n - 2] == 13) {
                ++n2;
            }
        }
        return EncodingUtil.getString(byArray, 0, n - n2, string);
    }

    public static String readLine(InputStream inputStream) throws IOException {
        LOG.trace("enter HttpParser.readLine(InputStream)");
        return HttpParser.readLine(inputStream, "US-ASCII");
    }

    public static Header[] parseHeaders(InputStream inputStream, String string) throws IOException, HttpException {
        String string2;
        LOG.trace("enter HeaderParser.parseHeaders(InputStream, String)");
        ArrayList<Header> arrayList = new ArrayList<Header>();
        String string3 = null;
        StringBuffer stringBuffer = null;
        while ((string2 = HttpParser.readLine(inputStream, string)) != null && string2.trim().length() >= 1) {
            int n;
            if (string2.charAt(0) == ' ' || string2.charAt(0) == '\t') {
                if (stringBuffer == null) continue;
                stringBuffer.append(' ');
                stringBuffer.append(string2.trim());
                continue;
            }
            if (string3 != null) {
                arrayList.add(new Header(string3, stringBuffer.toString()));
            }
            if ((n = string2.indexOf(":")) < 0) {
                throw new ProtocolException("Unable to parse header: " + string2);
            }
            string3 = string2.substring(0, n).trim();
            stringBuffer = new StringBuffer(string2.substring(n + 1).trim());
        }
        if (string3 != null) {
            arrayList.add(new Header(string3, stringBuffer.toString()));
        }
        return arrayList.toArray(new Header[arrayList.size()]);
    }

    public static Header[] parseHeaders(InputStream inputStream) throws IOException, HttpException {
        LOG.trace("enter HeaderParser.parseHeaders(InputStream, String)");
        return HttpParser.parseHeaders(inputStream, "US-ASCII");
    }
}

