/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppEngineWebXml {
    private final Map<String, String> systemProperties = Maps.newHashMap();
    private final Map<String, String> envVariables = Maps.newHashMap();
    private String appId;
    private String majorVersionId;
    private boolean sslEnabled = false;
    private boolean useSessions = false;
    private final List<String> staticFileIncludes = new ArrayList<String>();
    private final List<String> staticFileExcludes = new ArrayList<String>();
    private final List<String> resourceFileIncludes;
    private final List<String> resourceFileExcludes;
    private Pattern staticIncludePattern;
    private Pattern staticExcludePattern;
    private Pattern resourceIncludePattern;
    private Pattern resourceExcludePattern;
    private String appRoot;

    public AppEngineWebXml() {
        this.staticFileExcludes.add("WEB-INF/**");
        this.staticFileExcludes.add("**.jsp");
        this.resourceFileIncludes = new ArrayList<String>();
        this.resourceFileExcludes = new ArrayList<String>();
    }

    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(this.systemProperties);
    }

    public void addSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }

    public Map<String, String> getEnvironmentVariables() {
        return Collections.unmodifiableMap(this.envVariables);
    }

    public void addEnvironmentVariable(String key, String value) {
        this.envVariables.put(key, value);
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMajorVersionId() {
        return this.majorVersionId;
    }

    public void setMajorVersionId(String majorVersionId) {
        this.majorVersionId = majorVersionId;
    }

    public void setSslEnabled(boolean ssl) {
        this.sslEnabled = ssl;
    }

    public boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSessionsEnabled(boolean sessions) {
        this.useSessions = sessions;
    }

    public boolean getSessionsEnabled() {
        return this.useSessions;
    }

    public List<String> getStaticPatterns() {
        return this.staticFileIncludes;
    }

    public List<String> getStaticFileExcludes() {
        return this.staticFileExcludes;
    }

    public void includeStaticPattern(String url) {
        this.staticIncludePattern = null;
        this.staticFileIncludes.add(url);
    }

    public void excludeStaticPattern(String url) {
        this.staticExcludePattern = null;
        this.staticFileExcludes.add(url);
    }

    public List<String> getResourcePatterns() {
        return this.resourceFileIncludes;
    }

    public List<String> getResourceFileExcludes() {
        return this.resourceFileExcludes;
    }

    public void includeResourcePattern(String url) {
        this.resourceExcludePattern = null;
        this.resourceFileIncludes.add(url);
    }

    public void excludeResourcePattern(String url) {
        this.resourceIncludePattern = null;
        this.resourceFileExcludes.add(url);
    }

    public String toString() {
        return "App Id: " + this.appId + "\nApp Version: " + this.majorVersionId + "\nSystem props: " + this.systemProperties.toString() + "\nEnv variables: " + this.envVariables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppEngineWebXml that = (AppEngineWebXml)o;
        if (this.appId != null ? !this.appId.equals(that.appId) : that.appId != null) {
            return false;
        }
        if (!((Object)this.envVariables).equals(that.envVariables)) {
            return false;
        }
        if (!((Object)this.systemProperties).equals(that.systemProperties)) {
            return false;
        }
        return !(this.majorVersionId != null ? !this.majorVersionId.equals(that.majorVersionId) : that.majorVersionId != null);
    }

    public int hashCode() {
        int result = ((Object)this.systemProperties).hashCode();
        result = 31 * result + ((Object)this.envVariables).hashCode();
        result = 31 * result + (this.appId != null ? this.appId.hashCode() : 0);
        result = 31 * result + (this.majorVersionId != null ? this.majorVersionId.hashCode() : 0);
        return result;
    }

    public boolean includesResource(String path) {
        if (this.resourceIncludePattern == null) {
            this.resourceIncludePattern = this.resourceFileIncludes.size() == 0 ? Pattern.compile(".*") : Pattern.compile(this.makeRegexp(this.resourceFileIncludes));
        }
        if (this.resourceExcludePattern == null && this.resourceFileExcludes.size() > 0) {
            this.resourceExcludePattern = Pattern.compile(this.makeRegexp(this.resourceFileExcludes));
        }
        return this.includes(path, this.resourceIncludePattern, this.resourceExcludePattern);
    }

    public boolean includesStatic(String path) {
        if (this.staticIncludePattern == null) {
            this.staticIncludePattern = this.staticFileIncludes.size() == 0 ? Pattern.compile(".*") : Pattern.compile(this.makeRegexp(this.staticFileIncludes));
        }
        if (this.staticExcludePattern == null && this.staticFileExcludes.size() > 0) {
            this.staticExcludePattern = Pattern.compile(this.makeRegexp(this.staticFileExcludes));
        }
        return this.includes(path, this.staticIncludePattern, this.staticExcludePattern);
    }

    public boolean includes(String path, Pattern includes, Pattern excludes) {
        assert (includes != null);
        if (!includes.matcher(path).matches()) {
            return false;
        }
        return excludes == null || !excludes.matcher(path).matches();
    }

    public String makeRegexp(List<String> patterns) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String item : patterns) {
            if (first) {
                first = false;
            } else {
                builder.append('|');
            }
            while (item.charAt(0) == '/') {
                item = item.substring(1);
            }
            builder.append('(');
            if (this.appRoot != null) {
                builder.append(AppEngineWebXml.makeFileRegex(this.appRoot));
            }
            builder.append("/");
            builder.append(AppEngineWebXml.makeFileRegex(item));
            builder.append(')');
        }
        return builder.toString();
    }

    static String makeFileRegex(String fileGlob) {
        fileGlob = fileGlob.replaceAll("([^A-Za-z0-9\\-_/])", "\\\\$1");
        fileGlob = fileGlob.replaceAll("\\\\\\*\\\\\\*", ".*");
        fileGlob = fileGlob.replaceAll("\\\\\\*", "[^/]*");
        return fileGlob;
    }

    public void setSourcePrefix(String appRoot) {
        this.appRoot = appRoot;
    }
}

