/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.store.mapped.StatementMappingIndex;

public class StatementResultMapping {
    Map<Integer, StatementMappingIndex> mappings = null;

    public StatementMappingIndex getMappingForResultExpression(int position) {
        if (this.mappings == null) {
            return null;
        }
        return this.mappings.get(position);
    }

    public void addMappingForResultExpression(int position, StatementMappingIndex mapping) {
        if (this.mappings == null) {
            this.mappings = new HashMap<Integer, StatementMappingIndex>();
        }
        this.mappings.put(position, mapping);
    }

    public boolean isEmpty() {
        return this.mappings == null || this.mappings.size() == 0;
    }

    public int getNumberOfResultExpressions() {
        return this.mappings != null ? this.mappings.size() : 0;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("StatementResults:");
        if (this.mappings != null) {
            Iterator<Map.Entry<Integer, StatementMappingIndex>> mapIter = this.mappings.entrySet().iterator();
            while (mapIter.hasNext()) {
                Map.Entry<Integer, StatementMappingIndex> entry = mapIter.next();
                str.append(" position=").append(entry.getKey());
                str.append(" mapping=").append(entry.getValue());
                if (!mapIter.hasNext()) continue;
                str.append(",");
            }
        }
        return str.toString();
    }
}

