/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.behavior;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.ClassDesc;
import org.t2framework.commons.meta.Config;
import org.t2framework.lucy.Lifecycle;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.inject.ConstructorInjector;
import org.t2framework.lucy.inject.Injector;
import org.t2framework.lucy.inject.SimpleConstructorInjector;
import org.t2framework.lucy.spi.AbstractBehavior;

public abstract class AbstractComponentCreationBehavior
extends AbstractBehavior {
    protected Lock lock = new ReentrantLock();
    protected final Injector injector;

    public AbstractComponentCreationBehavior(BeanDesc<?> beanDesc, ClassDesc<?> classDesc, Config cd) {
        super(beanDesc, classDesc, cd);
        this.injector = beanDesc.getConstructorDesc().hasOnlyDefaultConstructor() ? new SimpleConstructorInjector(beanDesc) : new ConstructorInjector(beanDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(T t, Lucy lucy) {
        this.lock.lock();
        try {
            t = this.handleComponentCreation(t, lucy, this.getBeanDesc());
        }
        finally {
            this.lock.unlock();
        }
        return t;
    }

    protected abstract <T> T handleComponentCreation(T var1, Lucy var2, BeanDesc<Object> var3);

    @Override
    public final Lifecycle getLifecycle() {
        return Lifecycle.COMPONENT_CREATING;
    }

    protected Injector getInjector() {
        return this.injector;
    }
}

