/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.config.stax;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.ResourceUtil;
import org.t2framework.commons.util.StAXUtil;
import org.t2framework.commons.util.StreamUtil;
import org.t2framework.commons.util.URLUtil;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.config.stax.Attributes;
import org.t2framework.lucy.config.stax.LucyEventFilter;
import org.t2framework.lucy.config.stax.LucyXmlResolver;
import org.t2framework.lucy.config.stax.XMLEventReaderDelegate;
import org.t2framework.lucy.config.stax.XmlEventContext;
import org.t2framework.lucy.config.stax.XmlEventHandler;
import org.t2framework.lucy.config.stax.XmlEventHandlerRule;
import org.t2framework.lucy.exception.TagHandlerNotFoundException;

public class StAXParser {
    protected final XmlEventHandlerRule rule;
    protected final XMLInputFactory factory;
    protected final LucyEventFilter filter = new LucyEventFilter();

    public StAXParser(XmlEventHandlerRule rule) {
        this.rule = (XmlEventHandlerRule)Assertion.notNull((Object)rule);
        this.factory = XMLInputFactory.newInstance();
        this.factory.setXMLResolver(new LucyXmlResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Lucy lucy, String path) {
        BufferedInputStream bis = this.getBufferedInputStream(path);
        XMLEventReaderDelegate reader = null;
        try {
            XMLEventReader org = StAXUtil.createXMLEventReader((XMLInputFactory)this.factory, (InputStream)bis);
            XMLEventReader filteredReader = StAXUtil.createFilteredReader((XMLInputFactory)this.factory, (XMLEventReader)org, (EventFilter)this.filter);
            reader = new XMLEventReaderDelegate(filteredReader);
            XmlEventContext context = new XmlEventContext(lucy);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                context.setCurrentEvent(event);
                if (event.isStartElement()) {
                    StartElement se = event.asStartElement();
                    Attributes attributes = new Attributes(se);
                    String tagname = se.getName().getLocalPart();
                    XmlEventHandler handler = this.getHandler(tagname);
                    handler.start(context, attributes);
                    continue;
                }
                if (event.isEndElement()) {
                    EndElement ee = event.asEndElement();
                    String tagname = ee.getName().getLocalPart();
                    XmlEventHandler handler = this.getHandler(tagname);
                    String body = context.popBody();
                    handler.end(context, body);
                    continue;
                }
                if (!event.isCharacters()) continue;
                Characters c = event.asCharacters();
                context.pushBody(c.getData());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (bis != null) {
                StreamUtil.close((InputStream)bis);
            }
        }
    }

    protected XmlEventHandler getHandler(String tagname) {
        XmlEventHandler handler = this.rule.getHandler(tagname);
        if (handler == null) {
            throw new TagHandlerNotFoundException(tagname);
        }
        return handler;
    }

    protected BufferedInputStream getBufferedInputStream(String path) {
        URL url = ResourceUtil.getResource((String)path);
        return new BufferedInputStream(URLUtil.openStream((URL)url));
    }
}

