/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.el.mvel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.mvel2.ParserContext;
import org.t2framework.commons.Disposable;
import org.t2framework.commons.Disposer;
import org.t2framework.commons.el.Expression;
import org.t2framework.commons.exception.IORuntimeException;
import org.t2framework.commons.module.Modules;
import org.t2framework.commons.util.Reflections;
import org.t2framework.commons.util.ResourceUtil;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.LucyBootstrap;
import org.t2framework.lucy.el.AbstractExpressionFactory;
import org.t2framework.lucy.el.ExpressionNameResolver;
import org.t2framework.lucy.el.mvel.MVELExpression;

public class MVELExpressionFactory
extends AbstractExpressionFactory {
    private static final String PATH = "META-INF/services/el.properties";
    protected Set<String> defaultPackages = new HashSet<String>();
    protected ExpressionNameResolver resolver;

    public MVELExpressionFactory() {
        Disposer.add((Disposable)new Disposable(){

            public void dispose() {
                MVELExpressionFactory.this.clear();
            }
        });
        this.initialize();
    }

    protected void initialize() {
        this.defaultPackages.add(Reflections.PackageUtil.getPackageName(Disposer.class));
        this.defaultPackages.add(Reflections.PackageUtil.getPackageName(Modules.class));
        this.defaultPackages.add(Reflections.PackageUtil.getPackageName(LucyBootstrap.class));
        this.defaultPackages.add(Reflections.PackageUtil.getPackageName(StringUtil.class));
    }

    @Override
    public Map<String, Class<?>> resolve() {
        HashMap ret = new HashMap();
        InputStream is = ResourceUtil.getResourceAsStreamNoException((String)PATH);
        if (is == null) {
            return ret;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            Class c;
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            if (StringUtil.isEmpty((String)value) || (c = Reflections.ClassUtil.forNameNoException((String)value)) == null) continue;
            ret.put(key, c);
        }
        ExpressionNameResolver resolver = this.getExpressionNameResolver();
        if (resolver != null) {
            ret.putAll(resolver.resolve());
        }
        return ret;
    }

    @Override
    protected Expression<Lucy> doCreateExpression(String source, Map<String, Class<?>> namingContext) {
        ParserContext context = new ParserContext();
        for (String string : this.defaultPackages) {
            context.addPackageImport(string);
        }
        if (namingContext != null && !namingContext.isEmpty()) {
            for (Map.Entry entry : namingContext.entrySet()) {
                context.addImport((String)entry.getKey(), (Class)entry.getValue());
            }
        }
        return new MVELExpression(source, context);
    }

    @Override
    public void setExpressionNameResolver(ExpressionNameResolver resolver) {
        this.resolver = resolver;
    }

    public ExpressionNameResolver getExpressionNameResolver() {
        return this.resolver;
    }

    protected void clear() {
        this.resolver = null;
    }
}

