/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.ut;

import org.t2framework.commons.ut.BaseTestCase;
import org.t2framework.commons.ut.DefaultUtPlugin;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.LucyBootstrap;
import org.t2framework.lucy.impl.DefaultLucyConfiguration;
import org.t2framework.lucy.spi.LucyConfiguration;
import org.t2framework.lucy.ut.LucyTestCase;

public class LucyUtPlugin
extends DefaultUtPlugin {
    protected LucyConfiguration configuration;
    protected Object componentDefinition;

    public LucyUtPlugin(LucyTestCase testCase) {
        this(testCase, testCase.getLucyConfiguration());
    }

    public LucyUtPlugin(LucyTestCase testCase, LucyConfiguration configuration) {
        this(testCase, configuration, null);
    }

    public LucyUtPlugin(LucyTestCase testCase, LucyConfiguration configuration, Object componentDefinition) {
        super((BaseTestCase)testCase);
        this.configuration = configuration;
        this.componentDefinition = componentDefinition;
    }

    public void begin() throws Throwable {
        LucyConfiguration configuration = this.getConfiguration();
        if (configuration == null) {
            throw new NullPointerException("lucy configuration must not be null.");
        }
        LucyBootstrap.init(configuration, this.getComponentDefinition());
    }

    public void end() throws Throwable {
        LucyBootstrap.destroy();
    }

    public Lucy getLucy() {
        return LucyBootstrap.getLucy();
    }

    protected LucyConfiguration getConfiguration() {
        return this.configuration != null ? this.configuration : new DefaultLucyConfiguration();
    }

    protected Object getComponentDefinition() {
        return this.componentDefinition;
    }
}

