/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.users.dev;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginCookieUtils {
    private static final String COOKIE_PATH = "/";
    private static final String COOKIE_NAME = "ahlogincookie";
    private static final int COOKIE_AGE = -1;

    public static Cookie createCookie(String email, boolean isAdmin) {
        Cookie cookie = new Cookie(COOKIE_NAME, email + ":" + isAdmin);
        cookie.setPath(COOKIE_PATH);
        cookie.setMaxAge(-1);
        return cookie;
    }

    public static void removeCookie(HttpServletRequest req, HttpServletResponse resp) {
        Cookie cookie = LoginCookieUtils.findCookie(req);
        if (cookie != null) {
            cookie.setPath(COOKIE_PATH);
            cookie.setMaxAge(0);
            resp.addCookie(cookie);
        }
    }

    public static CookieData getCookieData(HttpServletRequest req) {
        Cookie cookie = LoginCookieUtils.findCookie(req);
        if (cookie == null) {
            return null;
        }
        return LoginCookieUtils.parseCookie(cookie);
    }

    private static CookieData parseCookie(Cookie cookie) {
        String value = cookie.getValue();
        String[] parts = value.split(":");
        return new CookieData(parts[0], Boolean.parseBoolean(parts[1]));
    }

    private static Cookie findCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(COOKIE_NAME)) continue;
                return cookie;
            }
        }
        return null;
    }

    private LoginCookieUtils() {
    }

    public static class CookieData {
        private final String email;
        private final boolean isAdmin;

        CookieData(String email, boolean isAdmin) {
            this.email = email;
            this.isAdmin = isAdmin;
        }

        public String getEmail() {
            return this.email;
        }

        public boolean isAdmin() {
            return this.isAdmin;
        }
    }
}

