/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.cache.impl;

import java.util.Map;
import org.t2framework.commons.cache.CacheSynchronization;
import org.t2framework.commons.cache.CacheType;
import org.t2framework.commons.cache.impl.AbstractCache;
import org.t2framework.commons.util.LRUHashMap;

public class LRUCache<K, V>
extends AbstractCache<K, V> {
    protected Map<K, V> cache = null;
    protected int limitSize = 32;
    protected int initialCapacity;
    protected final Object lock = new Object();

    public LRUCache(CacheSynchronization sync, int initialCapacity, int limitSize) {
        super(sync, initialCapacity);
        this.limitSize = limitSize;
        this.initialCapacity = initialCapacity;
    }

    @Override
    protected void createCache(CacheSynchronization sync, int initialCapacity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<K, V> getCache() {
        if (this.cache == null) {
            Object object = this.lock;
            synchronized (object) {
                this.cache = this.sync.getCache(new LRUHashMap(this.limitSize, this.initialCapacity));
            }
        }
        return this.cache;
    }

    @Override
    public CacheType getCacheType() {
        return CacheType.LRU;
    }
}

