/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;

public class BeanDescSupport<T> {
    protected static final Set<Method> ignores = CollectionsUtil.newHashSet();
    protected final BeanDesc<T> beanDesc;

    public BeanDescSupport(BeanDesc<T> beanDesc) {
        this.beanDesc = beanDesc;
    }

    public boolean isIgnorableMethod(Method m) {
        String methodName = m.getName();
        if ("isBridge".equals(methodName) || "isSynthetic".equals(methodName)) {
            return true;
        }
        for (Method ignoreMethod : ignores) {
            if (!ignoreMethod.equals(m)) continue;
            return true;
        }
        return false;
    }

    public void addIgnore(Method m) {
        ignores.add(Assertion.notNull(m));
    }

    public void clear() {
        ignores.clear();
        BeanDescSupport.init();
    }

    private static void init() {
        ignores.addAll(Arrays.asList(Object.class.getDeclaredMethods()));
    }

    static {
        BeanDescSupport.init();
    }
}

