/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.t2framework.commons.util.ArrayUtil;
import org.t2framework.commons.util.StringUtil;

public class DecimalFormatUtil {
    protected static Character[] SPECIAL_CURRENCY_SYMBOLS = new Character[]{Character.valueOf('\\'), Character.valueOf('$')};
    protected static boolean initialized = false;

    public static String normalize(String s) {
        return DecimalFormatUtil.normalize(s, Locale.getDefault());
    }

    public static String normalize(String s, Locale locale) {
        if (StringUtil.isEmpty(s)) {
            return null;
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        char groupingSeparator = symbols.getGroupingSeparator();
        char decimalSeparator = symbols.getDecimalSeparator();
        StringBuilder builder = new StringBuilder(20);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == groupingSeparator) continue;
            if (c == decimalSeparator) {
                c = '.';
            } else if (ArrayUtil.contains(SPECIAL_CURRENCY_SYMBOLS, Character.valueOf(c))) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static void addSpecialCharacterSymbol(char c) {
        ArrayUtil.add(SPECIAL_CURRENCY_SYMBOLS, Character.valueOf(c));
    }
}

