/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;

public class LazyLoadingReference<T> {
    protected Factory<T> factory;
    protected AtomicReference<WeakReference<Future<T>>> reference = new AtomicReference();

    public LazyLoadingReference(Factory<T> factory) {
        this.factory = factory;
    }

    /*
     * Loose catch block
     */
    public T get() throws IllegalStateException {
        while (true) {
            FutureTask f;
            WeakReference<Future<T>> ref = this.reference.get();
            boolean valid = true;
            if (ref == null && (valid = this.reference.compareAndSet(null, ref = new WeakReference(f = new FutureTask(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return LazyLoadingReference.this.factory.create();
                }
            }))))) {
                f.run();
            }
            if (!valid) continue;
            try {
                f = (FutureTask)ref.get();
                if (f != null) {
                    return (T)f.get();
                }
                this.reference.compareAndSet(ref, null);
                continue;
            }
            catch (CancellationException e) {
                this.reference.compareAndSet(ref, null);
                continue;
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e.getCause());
            }
            break;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static interface Factory<T> {
        public T create() throws CancellationException, Exception;
    }
}

