/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.t2framework.commons.util.ResourceBundleUtil;

public class MessageFormatter {
    private static final String MESSAGES = "Messages";

    private MessageFormatter() {
    }

    public static String getMessage(String messageCode, Object[] args) {
        if (messageCode == null) {
            messageCode = "";
        }
        return "[" + messageCode + "]" + MessageFormatter.getSimpleMessage(messageCode, args);
    }

    public static String getSimpleMessageNoCache(String messageCode, Object[] arguments) {
        return MessageFormatter.getSimpleMessage0(messageCode, arguments, false);
    }

    public static String getSimpleMessage(String messageCode, Object[] arguments) {
        return MessageFormatter.getSimpleMessage0(messageCode, arguments, true);
    }

    private static String getSimpleMessage0(String messageCode, Object[] arguments, boolean cacheable) {
        try {
            String pattern = MessageFormatter.getPattern(messageCode, cacheable);
            if (pattern != null) {
                return MessageFormat.format(pattern, arguments);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return MessageFormatter.getNoPatternMessage(arguments);
    }

    protected static String getPattern(String messageCode, boolean cacheable) {
        ResourceBundle resourceBundle = MessageFormatter.getMessages(MessageFormatter.getSystemName(messageCode), cacheable);
        if (resourceBundle != null) {
            return resourceBundle.getString(messageCode);
        }
        return null;
    }

    protected static String getSystemName(String messageCode) {
        if (messageCode.length() <= 4) {
            throw new IllegalStateException("messageCode length is more than 4. Format is [System code(D|I|E|T|W, 1char)][Message file name(any char length)][Message code name(4char)]");
        }
        return messageCode.substring(1, messageCode.length() - 4);
    }

    private static ResourceBundle getMessages(String systemName, boolean cacheable) {
        String baseName = systemName + MESSAGES;
        if (cacheable) {
            return ResourceBundle.getBundle(baseName);
        }
        return ResourceBundleUtil.getBundleNoCache(baseName);
    }

    private static String getNoPatternMessage(Object[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            builder.append(args[i] + ", ");
        }
        builder.setLength(builder.length() - 2);
        return builder.toString();
    }
}

