/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.exception.ForwardDispatchRuntimeException;
import org.t2framework.commons.exception.RedirectDispatchRuntimeException;
import org.t2framework.commons.util.ArrayUtil;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.StringUtil;

public class ServletUtil {
    public static void forward(RequestDispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) {
        Assertion.notNulls(dispatcher, request, response);
        try {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new ForwardDispatchRuntimeException(e);
        }
        catch (IOException e) {
            throw new ForwardDispatchRuntimeException(e);
        }
    }

    public static Map<String, String[]> parseParameters(String param, String encoding) throws UnsupportedEncodingException {
        HashMap<String, String[]> map = CollectionsUtil.newHashMap();
        StringTokenizer st = new StringTokenizer(param, "&");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String tkn = st.nextToken();
            int equal = tkn.indexOf("=");
            if (equal >= 0) {
                name = tkn.substring(0, equal);
                value = tkn.substring(equal + 1);
            } else {
                name = tkn;
                value = "";
            }
            name = URLDecoder.decode(name, encoding);
            value = URLDecoder.decode(value, encoding);
            String[] current = (String[])map.get(name);
            if (current == null) {
                map.put(name, new String[]{value});
                continue;
            }
            map.put(name, ArrayUtil.add(current, value));
        }
        return map;
    }

    public static void redirect(HttpServletResponse response, String path) {
        Assertion.notNulls(response, path);
        try {
            response.sendRedirect(path);
        }
        catch (IOException e) {
            throw new RedirectDispatchRuntimeException(e, path);
        }
    }

    public static boolean isMultipart(HttpServletRequest request) {
        Assertion.notNull(request);
        String method = request.getMethod().toUpperCase();
        if (!"POST".equals(method)) {
            return false;
        }
        String contentType = request.getContentType();
        if (StringUtil.isEmpty(contentType)) {
            return false;
        }
        return contentType.indexOf("multipart/") >= 0;
    }

    public static int getSizeParameter(FilterConfig filterConfig, String parameterName, int defaultValue) {
        Assertion.notNulls(filterConfig, parameterName);
        String param = filterConfig.getInitParameter(parameterName);
        if (StringUtil.isEmpty(param)) {
            return defaultValue;
        }
        param = param.toLowerCase();
        int factor = 1;
        String number = param;
        if (StringUtil.endsWithIgnoreCase(param, "g")) {
            factor = 0x40000000;
            number = param.substring(0, param.length() - 1);
        } else if (StringUtil.endsWithIgnoreCase(param, "m")) {
            factor = 0x100000;
            number = param.substring(0, param.length() - 1);
        } else if (StringUtil.endsWithIgnoreCase(param, "k")) {
            factor = 1024;
            number = param.substring(0, param.length() - 1);
        }
        return Integer.parseInt(number) * factor;
    }
}

