/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Wire {
    public static Wire HEADER_WIRE = new Wire(LogFactory.getLog("httpclient.wire.header"));
    public static Wire CONTENT_WIRE = new Wire(LogFactory.getLog("httpclient.wire.content"));
    private Log log;

    private Wire(Log log) {
        this.log = log;
    }

    private void wire(String string, InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) != -1) {
            if (n == 13) {
                stringBuffer.append("[\\r]");
                continue;
            }
            if (n == 10) {
                stringBuffer.append("[\\n]\"");
                stringBuffer.insert(0, "\"");
                stringBuffer.insert(0, string);
                this.log.debug(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            if (n < 32 || n > 127) {
                stringBuffer.append("[0x");
                stringBuffer.append(Integer.toHexString(n));
                stringBuffer.append("]");
                continue;
            }
            stringBuffer.append((char)n);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append("\"");
            stringBuffer.insert(0, "\"");
            stringBuffer.insert(0, string);
            this.log.debug(stringBuffer.toString());
        }
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    public void output(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.wire(">> ", inputStream);
    }

    public void input(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.wire("<< ", inputStream);
    }

    public void output(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.wire(">> ", new ByteArrayInputStream(byArray, n, n2));
    }

    public void input(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.wire("<< ", new ByteArrayInputStream(byArray, n, n2));
    }

    public void output(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.wire(">> ", new ByteArrayInputStream(byArray));
    }

    public void input(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.wire("<< ", new ByteArrayInputStream(byArray));
    }

    public void output(int n) throws IOException {
        this.output(new byte[]{(byte)n});
    }

    public void input(int n) throws IOException {
        this.input(new byte[]{(byte)n});
    }

    public void output(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.output(string.getBytes());
    }

    public void input(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.input(string.getBytes());
    }
}

