/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.apphosting.api.DatastorePb;
import java.util.HashSet;
import java.util.Iterator;

class NormalizedQuery {
    protected final DatastorePb.Query query;

    public NormalizedQuery(DatastorePb.Query query) {
        this.query = (DatastorePb.Query)query.clone();
        this.normalizeQuery();
    }

    DatastorePb.Query getQuery() {
        return this.query;
    }

    private void normalizeQuery() {
        for (DatastorePb.Query.Filter f : this.query.filters()) {
            if (f.propertySize() != 1 || f.getOpEnum() != DatastorePb.Query.Filter.Operator.IN) continue;
            f.setOp(DatastorePb.Query.Filter.Operator.EQUAL);
        }
        HashSet<String> properties = new HashSet<String>();
        for (DatastorePb.Query.Filter f : this.query.filters()) {
            if (f.getOpEnum() != DatastorePb.Query.Filter.Operator.EQUAL || f.propertySize() < 1) continue;
            properties.add(f.getProperty(0).getName());
        }
        Iterator i = this.query.orderIterator();
        while (i.hasNext()) {
            if (properties.add(((DatastorePb.Query.Order)i.next()).getProperty())) continue;
            i.remove();
        }
        for (DatastorePb.Query.Filter f : this.query.filters()) {
            if (f.getOpEnum() != DatastorePb.Query.Filter.Operator.EQUAL || f.propertySize() < 1 || !f.getProperty(0).getName().equals("__key__")) continue;
            this.query.clearOrder();
            break;
        }
        boolean foundKeyOrder = false;
        Iterator i2 = this.query.orderIterator();
        while (i2.hasNext()) {
            String property = ((DatastorePb.Query.Order)i2.next()).getProperty();
            if (foundKeyOrder) {
                i2.remove();
                continue;
            }
            if (!property.equals("__key__")) continue;
            foundKeyOrder = true;
        }
    }
}

