/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.contexts.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.BeanDescFactory;
import org.t2framework.commons.meta.ClassDesc;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Reflections;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.t2.contexts.ActionMethodDesc;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.contexts.impl.ActionMethodUtil;
import org.t2framework.t2.util.UrlTemplate;

public class PageDescImpl
implements PageDesc {
    protected String packageName;
    protected String pageName;
    protected MethodDesc defaultMethod;
    protected ClassDesc<?> pageClassDesc;
    protected List<Pattern> patterns = CollectionsUtil.newArrayList();
    protected ActionMethodDesc actionMethodDesc;
    protected UrlTemplate template;
    protected final Set<Class<? extends Annotation>> actionAnnotationSet;

    public PageDescImpl(Class<?> clazz, UrlTemplate template, Set<Class<? extends Annotation>> actionAnnotationSet) {
        this(Reflections.PackageUtil.getPackageName((Class)((Class)Assertion.notNull(clazz))), Reflections.ClassUtil.getShortClassName(clazz), BeanDescFactory.getBeanDesc(clazz), (UrlTemplate)Assertion.notNull((Object)template), actionAnnotationSet);
    }

    public PageDescImpl(String packageName, String shortClassName, BeanDesc<?> beanDesc, UrlTemplate template, Set<Class<? extends Annotation>> actionAnnotationSet) {
        Assertion.notNulls((Object[])new Object[]{beanDesc, packageName, shortClassName, template});
        this.packageName = (String)Assertion.notNull((Object)packageName);
        this.pageName = (String)Assertion.notNull((Object)shortClassName);
        this.template = template;
        this.actionAnnotationSet = (Set)Assertion.notNull(actionAnnotationSet);
        this.initActionMethodDesc(beanDesc);
    }

    protected void initActionMethodDesc(BeanDesc<?> beanDesc) {
        this.pageClassDesc = beanDesc.getClassDesc();
        this.actionMethodDesc = ActionMethodUtil.createActionMethodDesc(beanDesc, this.actionAnnotationSet);
        MethodDesc defaultMethod = ActionMethodUtil.resolveDefaultMethodDesc(beanDesc);
        if (defaultMethod != null) {
            this.actionMethodDesc.addDefaultMethodDesc(defaultMethod);
            this.defaultMethod = defaultMethod;
        }
    }

    @Override
    public MethodDesc getDefaultMethodDesc() {
        return this.defaultMethod;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getPageName() {
        return this.pageName;
    }

    @Override
    public ClassDesc<?> getPageClassDesc() {
        return this.pageClassDesc;
    }

    @Override
    public boolean match(String url) {
        if (StringUtil.isEmpty((String)url)) {
            return false;
        }
        String pagePath = this.normalize(url);
        boolean match = this.template.match(pagePath);
        if (match) {
            return true;
        }
        if (this.template.getTemplatePath().equals(url)) {
            return true;
        }
        return url.equalsIgnoreCase(this.pageName);
    }

    protected String normalize(String url) {
        String normalized = this.normalize0(url);
        int pos = this.findPosition(normalized);
        return normalized.substring(0, pos);
    }

    protected int findPosition(String normalized) {
        int pos = normalized.length();
        int count = StringUtil.counts((String)this.template.getTemplatePath(), (char)'/');
        int index = 0;
        for (int i = 0; i < normalized.length(); ++i) {
            if (index == count + 1) {
                pos = i - 1;
                break;
            }
            char c = normalized.charAt(i);
            if (c != '/') continue;
            ++index;
        }
        return pos;
    }

    protected String normalize0(String url) {
        boolean urlEndSlash;
        boolean urlStartSlash;
        String templatePath = this.template.getTemplatePath();
        boolean templateStartSlash = templatePath.indexOf("/") == 0;
        boolean bl = urlStartSlash = url.indexOf("/") == 0;
        url = templateStartSlash ? (urlStartSlash ? url : "/" + url) : (urlStartSlash ? url.substring(1) : url);
        boolean templateEndSlash = templatePath.lastIndexOf("/") == templatePath.length() - 1;
        boolean bl2 = urlEndSlash = url.lastIndexOf("/") == url.length() - 1;
        url = templateEndSlash ? (urlEndSlash ? url : url + "/") : (urlEndSlash ? url.substring(0, url.length() - 1) : url);
        return url;
    }

    @Override
    public ActionMethodDesc getActionMethodDesc() {
        return this.actionMethodDesc;
    }

    @Override
    public boolean hasDefaultMethodDesc() {
        return this.defaultMethod != null;
    }

    @Override
    public UrlTemplate getUrlTemplate() {
        return this.template;
    }

    @Override
    public String getPageTemplatePath() {
        return this.template.getTemplatePath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionAnnotationSet == null ? 0 : ((Object)this.actionAnnotationSet).hashCode());
        result = 31 * result + (this.actionMethodDesc == null ? 0 : this.actionMethodDesc.hashCode());
        result = 31 * result + (this.defaultMethod == null ? 0 : this.defaultMethod.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.pageClassDesc == null ? 0 : this.pageClassDesc.hashCode());
        result = 31 * result + (this.pageName == null ? 0 : this.pageName.hashCode());
        result = 31 * result + (this.patterns == null ? 0 : ((Object)this.patterns).hashCode());
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageDescImpl other = (PageDescImpl)obj;
        if (this.actionAnnotationSet == null ? other.actionAnnotationSet != null : !((Object)this.actionAnnotationSet).equals(other.actionAnnotationSet)) {
            return false;
        }
        if (this.actionMethodDesc == null ? other.actionMethodDesc != null : !this.actionMethodDesc.equals(other.actionMethodDesc)) {
            return false;
        }
        if (this.defaultMethod == null ? other.defaultMethod != null : !this.defaultMethod.equals(other.defaultMethod)) {
            return false;
        }
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        if (this.pageClassDesc == null ? other.pageClassDesc != null : !this.pageClassDesc.equals(other.pageClassDesc)) {
            return false;
        }
        if (this.pageName == null ? other.pageName != null : !this.pageName.equals(other.pageName)) {
            return false;
        }
        if (this.patterns == null ? other.patterns != null : !((Object)this.patterns).equals(other.patterns)) {
            return false;
        }
        return !(this.template == null ? other.template != null : !this.template.equals(other.template));
    }
}

