/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.contexts.impl;

import java.io.UnsupportedEncodingException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.exception.NoSuchComponentException;
import org.t2framework.commons.module.Modules;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.Reflections;
import org.t2framework.t2.adapter.ContainerAdapter;
import org.t2framework.t2.contexts.WebApplication;
import org.t2framework.t2.contexts.WebConfiguration;
import org.t2framework.t2.filter.T2ConfigurationUtil;
import org.t2framework.t2.handler.GlobalExceptionHandler;
import org.t2framework.t2.spi.AnnotationResolverCreator;
import org.t2framework.t2.spi.WebApplicationCreator;

public class WebConfigurationImpl
implements WebConfiguration {
    protected final FilterConfig config;
    protected final ContainerAdapter<?> containerAdapter;
    protected final AnnotationResolverCreator resolverCreator;
    protected final GlobalExceptionHandler globalExceptionHandler;
    protected WebApplication webApplication;

    public WebConfigurationImpl(FilterConfig config) throws ServletException {
        this.config = (FilterConfig)Assertion.notNull((Object)config);
        this.containerAdapter = this.getContainerAdapter(config, this.getUserConfigPath());
        this.globalExceptionHandler = this.containerAdapter.createGlobalExceptionHandler();
        this.resolverCreator = this.createResolverCreator();
        this.webApplication = this.createWebApplication();
    }

    protected AnnotationResolverCreator createResolverCreator() {
        AnnotationResolverCreator resolverCreator = (AnnotationResolverCreator)Modules.getService(AnnotationResolverCreator.class);
        if (resolverCreator == null) {
            throw new NoSuchComponentException(AnnotationResolverCreator.class);
        }
        return resolverCreator;
    }

    protected WebApplication createWebApplication() {
        WebApplicationCreator creator = (WebApplicationCreator)Modules.getService(WebApplicationCreator.class);
        if (creator == null) {
            throw new NoSuchComponentException(WebApplicationCreator.class);
        }
        return creator.createWebApplication(this);
    }

    @Override
    public void initialize() {
        this.getWebApplication().initialize();
    }

    @Override
    public AnnotationResolverCreator getResolverCreator() {
        return this.resolverCreator;
    }

    @Override
    public FilterConfig getFilterConfig() {
        return this.config;
    }

    @Override
    public String getEncoding() {
        return T2ConfigurationUtil.getEncoding(this.config);
    }

    @Override
    public String[] getRootPackages() {
        return T2ConfigurationUtil.getRootPackages(this.config);
    }

    @Override
    public String getUserConfigPath() {
        return T2ConfigurationUtil.getUserConfig(this.config);
    }

    @Override
    public String[] getExcludeResources() {
        return T2ConfigurationUtil.getExcludeResources(this.config);
    }

    @Override
    public ContainerAdapter<?> getContainerAdapter() {
        return this.containerAdapter;
    }

    @Override
    public boolean getEagerLoad() {
        return T2ConfigurationUtil.getEagerLoad(this.config);
    }

    protected ContainerAdapter<?> getContainerAdapter(FilterConfig config, String userConfigPath) throws ServletException {
        ContainerAdapter adapter = null;
        try {
            String adapterClass = T2ConfigurationUtil.getAdapterClass(config);
            Class c = Reflections.ClassUtil.forName((String)adapterClass);
            adapter = (ContainerAdapter)Reflections.ClassUtil.newInstance((Class)c);
            adapter.setFilterConfig(config);
            adapter.setServletContext(config.getServletContext());
            adapter.init(userConfigPath);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
        return adapter;
    }

    @Override
    public void setWebApplication(WebApplication webapp) {
        this.webApplication = webapp;
    }

    @Override
    public WebApplication getWebApplication() {
        return this.webApplication;
    }

    @Override
    public GlobalExceptionHandler getGlobalExceptionHandler() {
        return this.globalExceptionHandler;
    }

    @Override
    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    @Override
    public void setupRequestAndResponse(HttpServletRequest req, HttpServletResponse res) throws UnsupportedEncodingException {
        this.getContainerAdapter().setRequest(req);
        this.getContainerAdapter().setResponse(res);
        this.setupEncoding(req);
    }

    protected void setupEncoding(HttpServletRequest request) throws UnsupportedEncodingException {
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(this.getEncoding());
        }
    }

    @Override
    public void destroy() {
        this.getContainerAdapter().destroy();
        this.getWebApplication().destroy();
    }
}

