/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.navigation;

import org.t2framework.commons.Constants;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.util.JavaBeansUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.t2.annotation.core.Page;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.exception.InvalidClientCodeRuntimeException;
import org.t2framework.t2.navigation.WebNavigation;
import org.t2framework.t2.util.PathUtil;

public class Redirect
extends WebNavigation {
    private static Logger logger = Logger.getLogger(Redirect.class);
    protected RedirectTarget redirctTarget = RedirectTarget.SAME_CONTEXT;

    public static Redirect to(String path) {
        return new Redirect(path);
    }

    public static Redirect to(Class<?> pageClass) {
        return new Redirect(pageClass);
    }

    public static Redirect toOuterUrl(String url) {
        return new Redirect(url, RedirectTarget.OUTER_URL);
    }

    public static Redirect toOuterContext(String url) {
        return new Redirect(url, RedirectTarget.OUTER_CONTEXT);
    }

    public Redirect(String path) {
        super(path);
    }

    public Redirect(Class<?> pageClass) {
        super(pageClass);
    }

    public Redirect(String url, RedirectTarget redirctTarget) {
        super(url);
        this.redirctTarget = redirctTarget;
    }

    @Override
    public void execute(WebContext context) throws Exception {
        if (this.pageClass != null) {
            Config cd = this.classDesc.findConfig(Page.class);
            if (cd == null || !cd.hasAnnotation()) {
                logger.log("WTDT0019", null, new Object[]{this.getPageClass()});
                throw new InvalidClientCodeRuntimeException();
            }
            Page page = (Page)cd.getAnnotation();
            String realpath = page.value();
            if (StringUtil.isEmpty((String)realpath)) {
                realpath = this.toRealPath(context, JavaBeansUtil.decapitalize((String)this.pageClass.getSimpleName()));
            }
            this.redirect(context, realpath);
        } else {
            String realpath = this.redirctTarget == RedirectTarget.OUTER_URL ? this.path : this.toRealPath(context, this.path);
            this.redirect(context, realpath);
        }
    }

    protected String toRealPath(WebContext context, String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("http")) {
            logger.log("ITDT0021", null, Constants.EMPTY_ARRAY);
            return path;
        }
        if (!path.startsWith("/")) {
            logger.log("ITDT0022", null, new Object[]{"Redirect"});
            path = PathUtil.appendStartSlashIfNeed(path);
        }
        if (this.redirctTarget == RedirectTarget.OUTER_CONTEXT) {
            return path;
        }
        String contextPath = ((Request)context.getRequest()).getContextPath();
        return PathUtil.endsWithSlash(contextPath) ? PathUtil.removeEndSlashIfNeed(contextPath) + path : contextPath + path;
    }

    protected void redirect(WebContext context, String realPath) {
        context.redirect(realPath);
    }

    public static enum RedirectTarget {
        SAME_CONTEXT,
        OUTER_CONTEXT,
        OUTER_URL;

    }
}

