package com.shin1ogawa.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.google.appengine.api.datastore.Key;

@SuppressWarnings("serial")
@PersistenceCapable(identityType = IdentityType.APPLICATION)
public class ChildB implements Serializable {
	@PrimaryKey
	@Persistent(valueStrategy = IdGeneratorStrategy.IDENTITY)
	private Key key;

	@Persistent(mappedBy = "children")
	private ParentB ancestor;

	@Persistent
	private String value;

	@Persistent(defaultFetchGroup = "true", mappedBy = "ancestor")
	private List<ChildBChild> children = new ArrayList<ChildBChild>();

	public Key getKey() {
		return key;
	}

	public void setKey(Key key) {
		this.key = key;
	}

	/**
	 * @return the ancestor
	 */
	public ParentB getAncestor() {
		return ancestor;
	}

	/**
	 * @param ancestor
	 *            the ancestor to set
	 */
	public void setAncestor(ParentB ancestor) {
		this.ancestor = ancestor;
	}

	public String getValue() {
		return value;
	}

	public ChildB setValue(String value) {
		this.value = value;
		return this;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	/**
	 * @param children
	 *            the children to set
	 */
	public void setChildren(List<ChildBChild> children) {
		this.children = children;
	}

	/**
	 * @return the children
	 */
	public List<ChildBChild> getChildren() {
		return children;
	}
}
