<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://java.sun.com/jstl/core" prefix="c" %>

<html>
<head>
	<title>板: <c:out value="${board.title}" /></title>
</head>
<body>
<c:choose>
	<c:when test="${user != null}">
	<p>Hello, <c:out value="${user.nickname}" />! (You can <a href="<c:out value="${logoutUrl}" />">sign out</a>.)</p>
	</c:when>
	<c:otherwise>
	<p>Hello, <a href="<c:out value="${loginUrl}" />">Sign in</a> to include your name with your post.</p>
	</c:otherwise>
</c:choose>
<p><a href="/">板一覧</a></p>

<h1><c:out value="${board.title}" /></h1>
<c:choose>
<c:when test="${noMessages == true}">まだ投稿がありません。</c:when>
<c:otherwise>
<ul>
<c:forEach var="message" items="${board.messages}" varStatus="s">
	<li>[<c:out value="${s.index + 1}" />]<c:out value="${message.created}" />: 
	<c:choose>
	<c:when test="${message.user != null}"><c:out value="${message.user.nickname}" /></c:when>
	<c:otherwise>名無し</c:otherwise>
	</c:choose><br /><c:out value="${message.body}" /></li>
</c:forEach> 
</ul>
</c:otherwise>
</c:choose>

<form action="/message/post" method="post">
	<input type="hidden" name="boardId" value="<c:out value="${board.id}" />"/>
	<div><textarea name="body" rows="3" cols="100"></textarea></div>
	<div><input type="submit" value="New Message" /></div>
</form>

</body>
</html>
