package appengine.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

import org.apache.commons.lang.StringUtils;

/**
 * @author Shinichi Ogawa
 */
public class OneLineLogFormatter extends Formatter {

	DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.JAPAN);

	static final String LINE_SEPARATOR = System.getProperty("line.separator");


	@Override
	public String format(LogRecord record) {
		StringBuffer buffer = new StringBuffer();
		String loggerName = record.getLoggerName();
		if (StringUtils.isEmpty(loggerName)) {
			loggerName = "Anonymous logger";
		}
		buffer.append(record.getLevel().getName()).append(" ").append(
				dateFormat.format(new Date(record.getMillis()))).append(" : ").append(loggerName)
			.append(" : ").append(record.getMessage()).append(LINE_SEPARATOR);
		return buffer.toString();
	}
}
