#!/usr/bin/ruby -Ke
#
# (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
#
# $Id: GUI.rb,v 1.1 2008/10/05 01:33:42 nishimoto Exp $
#
# GUI for end-user
#
# based on Thread sample:
# http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/5321
#
# set Text = message
# set F1 = ʬ ե
#
#  F1 F2 F3 F4 F5 
#  F6 F7 F8 F9 F10
#
# set WebBrowser.url = http://www.mozilla.org/
#  >> mozilla -remote "openurl(http://www.mozilla.org)"
# set WebBrowser.url = file:/home/hil/nishi/public_html/index.shtml
#  >> mozilla -remote "openurl(file:/home/hil/nishi/public_html/index.shtml)"
#
# set Canvas.photo = earth.gif
#

# -------------

require 'GalateaBase.rb'
$tk_thread_safe = TRUE
require 'tk'
require 'open3'

# -------------

$tktext = nil

class GUI < GalateaBase
  def initialize
    super
    @modulename = "GUI"
    @debug = false

    @myslot["Run"] = "LIVE"
  end
  
  def do_set(slot, arg)
    super

    if slot == "Text"
      unless $tktext.nil?
      	$tktext.text arg
      end

#    elsif $use_canvas && slot == "Canvas.photo" 
#      image = TkPhotoImage.new('file' => arg, 'width' => 128, 'height' => 128)
#      TkcImage.new($tkcanvas,  145, 100, 'image' => image)
#      $tkcanvas.pack('fill'=>'both', 'expand' => true)

    elsif slot == "WebBrowser.url" 
#      Open3.popen3("mozilla -remote \"openurl(#{arg})\"")

    elsif slot == "Run" && arg =="EXIT"
      Process.exit!(0)

    elsif /(\S+)\s+(.*)/ =~ arg
      set_button slot, $1, $2

    end

  end

end

Thread.start do
  GUI.new.run
end

# -------------

class FuncButton 
  def initialize(parent, lbl, ev)
    @label = lbl
    @event = ev
    @button = TkButton.new(parent) {
      pack('side' => 'left')
    }
    @button.configure('text', @label)
    @button.bind("Button-1", proc { send_button_pressed(@event) })

    if /[0-9]/ =~ @label
      $root.bind("Key-#{@label}", proc { send_button_pressed(@event) })
    end

  end

  def label(str)
    @label = str
    @button.configure('text', @label)
  end

  def event(str)
    @event = str
  end

end

# -------------
def send_button_pressed(name)
  print_out "to \@SIM set ButtonPressed = " + name
  print_out "to \@MON set AppLogText = pressed " + name
end

# -------------
def set_button(name, label, event) 
  if name == 'F1' then
    $f1.label label
    $f1.event event

  elsif name == 'F2' then
    $f2.label label
    $f2.event event

  elsif name == 'F3' then
    $f3.label label
    $f3.event event

  elsif name == 'F4' then
    $f4.label label
    $f4.event event

  elsif name == 'F5' then
    $f5.label label
    $f5.event event

  elsif name == 'F6' then
    $f6.label label
    $f6.event event

  elsif name == 'F7' then
    $f7.label label
    $f7.event event

  elsif name == 'F8' then
    $f8.label label
    $f8.event event

  elsif name == 'F9' then
    $f9.label label
    $f9.event event

  elsif name == 'F10' then
    $f10.label label
    $f10.event event

  end
end

# -------------

$root = TkRoot.new

# -------------

#if $use_canvas 
# $tkcanvas = TkCanvas.new {
#   pack
# }    
#end

# -------------

$tktext = TkLabel.new {
  relief 'sunken'
  width 35
  pady 10
  borderwidth 3
  pack
}

# -------------

frame_bool = TkFrame.new {
  pack
}

fy = FuncButton.new(frame_bool, 'Ϥ', 'Ϥ')
fn = FuncButton.new(frame_bool, '', '')

# -------------

frame_f1 = TkFrame.new {
  pack
}

$f1 = FuncButton.new(frame_f1, 'F1', 'F1')
$f2 = FuncButton.new(frame_f1, 'F2', 'F2')
$f3 = FuncButton.new(frame_f1, 'F3', 'F3')
$f4 = FuncButton.new(frame_f1, 'F4', 'F4')
$f5 = FuncButton.new(frame_f1, 'F5', 'F5')

# -------------

frame_f2 = TkFrame.new {
  pack
}

$f6  = FuncButton.new(frame_f2, 'F6', 'F6')
$f7  = FuncButton.new(frame_f2, 'F7', 'F7')
$f8  = FuncButton.new(frame_f2, 'F8', 'F8')
$f9  = FuncButton.new(frame_f2, 'F9', 'F9')
$f10 = FuncButton.new(frame_f2, 'F10', 'F10')

# -------------

frame_num1 = TkFrame.new {
  pack
}

n1 = FuncButton.new(frame_num1, '1', '1')
n2 = FuncButton.new(frame_num1, '2', '2')
n3 = FuncButton.new(frame_num1, '3', '3')
n4 = FuncButton.new(frame_num1, '4', '4')
n5 = FuncButton.new(frame_num1, '5', '5')

# -------------

frame_num2 = TkFrame.new {
  pack
}

n6 = FuncButton.new(frame_num2, '6', '6')
n7 = FuncButton.new(frame_num2, '7', '7')
n8 = FuncButton.new(frame_num2, '8', '8')
n9 = FuncButton.new(frame_num2, '9', '9')
nzero = FuncButton.new(frame_num2, '0', '0')

# nstar  = FuncButton.new(frame_num4, '*', 'star-key')
# nsharp = FuncButton.new(frame_num4, '#', 'sharp-key')

# -------------

Tk.root.title("GUI")
Tk.mainloop

# end of file
