#!/usr/bin/ruby
# GalateaBase.rb
#
# Galatea Submodule base class
# by Takuya NISHIMOTO nishimotz@gmail.com
#

require 'thread'
require 'timeout'

# grobal method

def print_out(str)
  puts str
  STDOUT.flush
end

# class def.

class GalateaBase
  def initialize
    @modulename = "GalateaBase"
    @debug = false
    @myslot = {}
    @mymacro = {}
    @myprop = {}
    @mycount = {}
    #
    @myslot["Run"] = "DEAD" # or "LIVE"
    @myslot["ProtocolVersion"] = "ProtocolVersion 1.0"
    @myslot["ModuleVersion"] = "ModuleVersion 1.0"
    @alive_count = 1
    @check_alive = false
  end

  attr_accessor :modulename, :debug
  attr_accessor :check_alive

  def send_set(mod, slot, str)
    puts "to \@#{mod} set #{slot} = #{str}"
    STDOUT.flush
  end

  def print_out(str)
    puts str
    STDOUT.flush
  end

  def print_debug(str)
    if @debug
      #STDERR.puts @modulename + ": " + str
      #STDERR.flush
      #print_out "to \@MON set SysLogText = #{modulename} #{str}"
    end
  end

  def print_tell(str)
    puts "tell " + str
    STDOUT.flush
  end

  def print_rep(str)
    puts "rep " + str
    STDOUT.flush
  end

  def do_gets(rs = $/)
    if @check_alive
      s = nil
      while s == nil
        begin
          timeout(0.1) do
            s = $stdin.gets(rs)
          end
        rescue TimeoutError
          print_debug("alive_count #{@alive_count}")
          @alive_count += 1
        end
      end
      return s
    else
      $stdin.gets(rs)
    end
  end

  def run
    while true
      while cmd = do_gets
        case cmd
        when /^\s*set\s+([^\s=]*)\s*=\s*(.*)$/
          # set XXX = xxxx
          @myslot[$1] = $2
          do_set $1, $2
        when /^\s*prop\s+([^\s=]*)\s*=\s*(.*)$/
          # prop XXX.attr = xxx
          @myprop[$1] = $2
          do_prop $1, $2
        when /^\s*inq\s+(.*)$/
          # inq
          print_rep "#{$1} = #{@myslot[$1]}"
        when /^\s*From\s+\@(\S+)\s(.*)$/
          # (broadcast only) From @(XXX) (xxxxxxxx)
          accept_from $1, $2
        when /^\s*to\s+\@(\S+)\s(.*)$/
          # (broadcast only) to @(XXX) (xxxxxxxx)
          accept_to $1, $2
        end
        # not implemented:
        #
        # set XXX < filename
        #
        # set XXX << END
        # xxxx
        # END
      end
    end
  end

  def do_set(slot, arg)
    if slot == "Run" 
      if arg == "INIT"
        @myslot["Run"] = "LIVE"
      end
      if arg == "EXIT"
        @myslot["Run"] = "DEAD"
      end
    end
  end

  def do_prop(prop, arg)
  end

  def accept_from(mod, str)
  end

  def accept_to(mod, str)
  end

end

# end of file
