#!/usr/bin/ruby -Ke
# $Id: SND.rb,v 1.1 2008/10/05 01:33:42 nishimoto Exp $
#
# by Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
#
# set Play = /usr/share/sndconfig/sample.au
# set Play = STOP
# set Play = /data/video/kani030611.mpg

require 'GalateaBase.rb'

class SND < GalateaBase

  def initialize
    super
    @modulename = "SND"
    @debug = false

    @cmd = nil
    @arg = nil
    Thread.start do
      while true
    	if @cmd != nil
    	  print_tell "start #{@arg}"
    	  system @cmd
    	  print_tell "end #{@arg}"
    	  @cmd = nil
    	end
    	sleep 0.001
      end
    end
  end
  
  def do_set(slot, arg)
    super

    if slot == "Play" 
      if arg == "STOP" && @pid.to_i != 0
    	print_debug "killing #{@pid}"
    	Process.kill "SIGTERM", @pid
    	# not working...

      else
    	arg.gsub!( /^file:/, "" )
    	@arg = arg
    	if /\.mpg$/ =~ arg
    	  @cmd = "/usr/bin/gmplayer -fs -really-quiet #{arg}"
    	else
    	  # @cmd = "/usr/bin/play -v 0.2 #{arg}"
    	  @cmd = "/usr/bin/play -v 1.0 #{arg}"
    	end
	    print_debug "#{@cmd} #{@arg}"
      end
    end
  end

end

SND.new.run

# end of file
