/**
 * $Id: DocUtil.java,v 1.1 2008/10/05 01:33:42 nishimoto Exp $
 */
package galatea.document;

import galatea.relaxer.vxml20.IVxmlChoiceMixed;
import galatea.relaxer.vxml20.IVxmlGrammarChoice;
import galatea.relaxer.vxml20.IVxmlRuleMixed;
import galatea.relaxer.vxml20.IVxmlVxmlChoice;
import galatea.relaxer.vxml20.RString;
import galatea.relaxer.vxml20.VxmlForm;
import galatea.relaxer.vxml20.VxmlGrammar;
import galatea.relaxer.vxml20.VxmlMenu;
import galatea.relaxer.vxml20.VxmlRule;
import galatea.relaxer.vxml20.VxmlToken;
import galatea.relaxer.vxml20.VxmlVxml;
import galatea.util.Util;

/**
 * @author nishi
 *
 */
public class DocUtil {

	// DocUtil
	// in: "1s"   out:1000
	// in: "50ms" out:50
	public static int getCSS2TimesAsMsec(String in) {
		int n = 0;
		if (in.endsWith("ms")) {
			String num = in.substring(0,in.length()-2);
			n = Float.valueOf(num).intValue();
		} else if (in.endsWith("s")) {
			String num = in.substring(0,in.length()-1);
			float d = Float.valueOf(num).floatValue();
			n = new Float(d * 1000.0).intValue();
		}
		return n;
	}

	/**
	 * DocUtil
	 * @return 省略時の開始 dialog ID を取得 or null
	 * document order で先頭の form または menu 
	 */
	public static String getFirstDialogID(VxmlVxml vxmlVxml)
	{
		String firstId = null;
		//dbg.print( "vxml:" + vxmlVxml );
		int nContent = vxmlVxml.sizeContent();
		//dbg.print( "nContent:" + nContent,2);
		for ( int i = 0; i < nContent; i++ ) {
			IVxmlVxmlChoice choice = vxmlVxml.getContent(i);
			if ( choice instanceof VxmlForm ) {
				VxmlForm o = (VxmlForm)choice;
				firstId = o.getId();
				if ( firstId == null ) {
					o.setId("__form__");
					firstId = o.getId();
				}
				else if ( firstId.equals("") ) {
					o.setId("__form__");
					firstId = o.getId();
				}
				//dbg.print("firstId:" + firstId);
				break;
			} 
			else if ( choice instanceof VxmlMenu ) {
				VxmlMenu o = (VxmlMenu)choice;
				firstId = o.getId();
				if ( firstId == null ) {
					o.setId("__menu__");
					firstId = o.getId();
				}
				else if ( firstId.equals("") ) {
					o.setId("__menu__");
					firstId = o.getId();
				}
				//dbg.print("firstId:" + firstId);
				break;
			} 
		}
		return firstId;
	}

	// DocUtil
	public static String getText(IVxmlChoiceMixed cm)
	{
		String text = "";
		if ( cm instanceof RString ) {
			// <choice>coffee</choice>
			RString rs = (RString)cm;
			text = Util.removeSpaces(rs.getText());
		} else if ( cm instanceof VxmlGrammar ) {
			// <choice><rule><token>coffee</token></rule></choice>
			VxmlGrammar gram = (VxmlGrammar) cm;
			for ( int j = 0; j < gram.sizeContent(); j++ ) {
				IVxmlGrammarChoice gc = gram.getContent(j);
				if ( gc instanceof VxmlRule ) {
					VxmlRule rule = (VxmlRule) gc;
					for ( int k = 0; k < rule.sizeContent(); k++ ) {
						IVxmlRuleMixed rm = rule.getContent(k);
						if ( rm instanceof VxmlToken ) {
							VxmlToken gt = (VxmlToken)rm;
							text = Util.removeSpaces(gt.getContent());
						}
					}
				}
			}
		}
		return text;
	}

	public static String getCSS2TimesInMsecAsString(String value) {
		return Double.toString(DocUtil.getCSS2TimesAsMsec(value));
	}

}
