/**
 * $Id: GrammarSubModule.java,v 1.4 2009/01/25 12:54:54 nishimoto Exp $
 */
package galatea.io.julius;

import galatea.dialog.RuntimeError;
import galatea.logger.Logger;
import galatea.outitem.GrammarOutItem;
import galatea.outitem.OutItem;
import galatea.submodule.AbstractSubModule;
import galatea.util.Util;

import java.nio.charset.Charset;

public class GrammarSubModule extends AbstractSubModule {
	private final String XML_ENCODING = "UTF-8";
	private Logger logger_ = new Logger(this.getClass());
	private Charset charset_ = Util.getSystemDefaultCharset();
	private Charset xmlCharset_ = Charset.forName(XML_ENCODING);
	
	private String document_ = "";
	private String location_ = "";
	private String transformErrors_ = "";

	private final int STOPPED  = 0;
	private final int BUSY     = 1;
	private final int STOPPING = 2;
	private final int ERROR    = 3;
	private int state_ = STOPPED;

	public GrammarSubModule() {
		super();
		setName("GRM");
	}
	
	private synchronized void _setState(int newstate) {
		state_ = newstate;
	}
	
	private synchronized int _getState() {
		return state_;
	}
	
	public void doTimerTask() throws RuntimeError {
		switch (_getState()) {
		case ERROR:
			receiver_.receiveOutputReady("GrammarSubModule", "error");
			String err = transformErrors_;
			transformErrors_ = "";
			_setState(STOPPED);
			systemEventLogger_.fatalError(err);
			throw new RuntimeError(err);
		case STOPPING:
			receiver_.receiveOutputReady("GrammarSubModule", "done");
			_setState(STOPPED);
			break;
		}
	}
	
	public boolean startOutput(OutItem item) {
		if (!(item instanceof GrammarOutItem)) return false;
		GrammarOutItem g = (GrammarOutItem)item;
		document_ = "<?xml version=\"1.0\" encoding=\"" 
			+ XML_ENCODING + "\"?>" + g.getDocument();
		location_ = g.getLocation();
		receiver_.receiveOutputBusy("GrammarSubModule", "started");
		while (_getState() != STOPPED) {
			try {
				logger_.print("wait until STOPPED");
				Thread.sleep(100);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		logger_.print("startOutput("+location_+") "+document_);
		Thread th = new Thread(new Runnable() {
			public void run() {
				GrammarTransformer gt = new GrammarTransformer();
				if (gt.doTransformAndCompile(document_, location_) == false) {
					transformErrors_ =
						"doTransform " + location_ + "\n" 
						+ "[stderr]\n" + gt.getErrors() 
						+ "[stdout]\n" + gt.getOutputs();
					logger_.print(transformErrors_);
					_setState(ERROR);
				} else {
					transformErrors_ = "";
					_setState(STOPPING);
				}
			}
		});
		th.start();
		return true;
	}

	public boolean stopOutput(OutItem item) {
		if (!(item instanceof GrammarOutItem)) return false;
		_setState(STOPPING);
		return true;
	}

}
