/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 *
 * $Id: GrammarOutItem.java,v 1.2 2009/01/28 13:51:17 nishimoto Exp $
 */

package galatea.outitem;

import galatea.util.Property;
import galatea.util.Util;

public class GrammarOutItem extends OutItem
{
	private String grammar_;
	private String name_;
	private String dir_;
	
	public GrammarOutItem(String grammar, String name)
	{
		isInstant_ = false;
		isImportant_ = true;
		grammar_ = grammar;
		name_ = name;
		dir_ = Property.getForPlatformAsStr("Grammar.WorkDir", "/tmp");
	}
	
	public String toString()
	{
		return "<grammarout name=\"" + name_ + "\" dir=\"" + dir_ + "\"><![CDATA[" + grammar_ + "]]></grammarout>";
	}
	
	public String getDocument()
	{
		return grammar_;
	}
	
	public String getLocation()
	{
		return dir_ + "/" + name_;
	}
	
}
