/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 *
 *  $Id: NativeOutItem.java,v 1.2 2009/01/28 13:51:17 nishimoto Exp $
 */

package galatea.outitem;

import galatea.dialog.RuntimeError;


public class NativeOutItem extends OutItem 
{
	private String with_ = "";
	private String text_;
	
	public NativeOutItem(String text)
	{
		this(text, "");
	}
	
	public NativeOutItem(String text, String with)
	{
		isInstant_ = true;
		text_ = text;
		with_ = with;
	}
	
	public void setWith(String s) 
	{
		with_ = s;
	}
	
	public String getWith() 
	{
		return with_;
	}
	
	public void doEvaluate() throws RuntimeError
	{
		String script;
		if ( with_ != null && with_.length() > 0 ) {
			script = "with(" + with_ + "){" + text_ + "}";
		} else {
			script = text_;
		}
		arg_ = ecmascript_.evaluate(script);
	}
	
	public String toString()
	{
		String s = "<native";
		if ( with_ != null && with_.length() > 0 ) {
			s += " with=\"" + with_ + "\"";
		}
		s += ">";
		s += text_;
		s += "</native>";
		return s;
	}
	
}
