/* -*- Mode: java; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Galatea Behavior Manager:
 * (c)2010 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 */

package galatea.agent;

//import galatea.util.AMBuffer;
import galatea.util.Getopt;
import galatea.util.HashArray;

import java.text.DecimalFormat;
import java.util.regex.Matcher;

public class BehaviorManager extends GalateaBase
{
    java.util.Random random_;
    private HashArray agents_; // map String => Agent
    
    private long prevTime_;

    private boolean isFsmAlive_;
    private boolean useAutoMove_;
    private String currAgent_;

    private Vector3D prevEyeRot_ = new Vector3D(0, 0, 0);
    private Vector3D prevHeadRot_ = new Vector3D(0, 0, 0);
    private Vector3D prevBodyRot_ = new Vector3D(0, 0, 0);
    private Vector3D prevBodyTrans_ = new Vector3D(0, 0, 0);
    private Agent prevAgent_ = null;
    private double prevBodyScale_ = 0.0;
    private String prevExpType_ = "NEUTRAL";
    private double prevExpLevel_ = 0.0;

    private DecimalFormat formatter_;
    
    public final int faceUpdateCycle_ = 25;

    public BehaviorManager()
    {
        super();
        random_ = new java.util.Random();
        formatter_ = new DecimalFormat("0.000");

        isFsmAlive_ = false;
        useAutoMove_ = false;

        currAgent_ = AgentUtil.getDefaultAgent();
        agents_ = AgentUtil.loadAgents();
    }


    private String _format(double d)
    {
        return formatter_.format(d);
    }


    private Agent _getCurrAgent()
    {
        return (Agent)agents_.get(currAgent_);
    }


    private Agent _getAgentByName(String name)
    {
        return (Agent)agents_.get(name);
    }


    private void _outputFaceExp()
    {
        Agent agent = _getCurrAgent();
        boolean maskChanged = true;
        if ( agent == prevAgent_ ) {
            maskChanged = false;
        }

        Vector3D e = agent.getEyeRot();
        if ( maskChanged || (! e.equals(prevEyeRot_)) ) {
            send("to @FSM set EyeRot = " + _format(e.x) + " " + _format(e.y) + " " + _format(e.z));
        }
        
        Vector3D h = agent.getHeadRot();
        if ( maskChanged || (! h.equals(prevHeadRot_)) ) {
            send("to @FSM set HeadRotAbs.1 = " + _format(h.x) + " " + _format(h.y) + " " + _format(h.z));
        }
        
        Vector3D b = agent.getBodyRot();
        if ( maskChanged || (! b.equals(prevBodyRot_)) ) {
            send("to @FSM set AgentRot = " + _format(b.x) + " " + _format(b.y) + " " + _format(b.z));
        }
        
        Vector3D t = agent.getBodyTrans();
        if ( maskChanged || (! t.equals(prevBodyTrans_)) ) {
            send("to @FSM set AgentTrans = " + _format(t.x) + " " + _format(t.y));
        }

        double scale = agent.getBodyScale();
        if ( maskChanged 
             || Math.abs(scale - prevBodyScale_) > 0.01 ) {
            send("to @FSM set AgentScale = " + _format(scale));
        }

        String exptype = agent.getExpType();
        double explevel = agent.getExpLevel();
        if ( maskChanged 
             || ! exptype.equals(prevExpType_)
             || Math.abs(explevel - prevExpLevel_) > 3.0 ) {
            send("to @FSM set FaceExp = " + exptype + " 1 " + _format(explevel) + " 0");
        }

        prevAgent_ = agent;
        prevEyeRot_.set(e);
        prevHeadRot_.set(h);
        prevBodyRot_.set(b);
        prevBodyTrans_.set(t);
        prevBodyScale_ = scale;
        prevExpType_ = exptype;
        prevExpLevel_ = explevel;
    }


    private void _setupCurrMask()
    {
        String bg = _getCurrAgent().getBackground();
        String mask = _getCurrAgent().getMask();
        send("to @FSM set Background = " + bg);
        send("to @FSM set Mask = " + mask);
        _outputFaceExp();
    }


    public void handleRep(String module, String slot, String arg)
    {
        if (module.equals("FSM") && slot.equals("Run") && arg.equals("LIVE")) {
            isFsmAlive_ = true;
        }
    }


    private void _sendFadeOut()
    {
        send("to @FSM set AgentEnable = DISABLE");
    }
    
    
    private void _sendFadeIn()
    {
        send("to @FSM set AgentEnable = ENABLE");
    }
    
    
    public void handleSet(String module, String slot, String arg)
    {
        if (slot.equals("AutoMove")) {
            useAutoMove_ = (Integer.parseInt(arg) == 0) ? false : true;
            if (useAutoMove_) {
                _setupCurrMask();
            }

        } else if (slot.equals("AgentSpeakState")) {
            _getCurrAgent().setAgentSpeakState(Integer.parseInt(arg));

        } else if (slot.equals("Emotion")) {
            Matcher matcher2 = pattern2_.matcher(arg);
            if (matcher2.matches()) {
                String type = matcher2.group(1);
                double level = Double.parseDouble(matcher2.group(2));
                _getCurrAgent().setEmotionTarget(type, level);
            } else {
                _getCurrAgent().setEmotionTarget(arg);
            }
        } else if (slot.equals("EmotionNow")) {
            Matcher matcher2 = pattern2_.matcher(arg);
            if (matcher2.matches()) {
                String type = matcher2.group(1);
                double level = Double.parseDouble(matcher2.group(2));
                _getCurrAgent().setEmotionNow(type, level);
            } else {
                _getCurrAgent().setEmotionNow(arg);
            }
        } else if (slot.equals("Rot")) {
            Matcher matcher3 = pattern3_.matcher(arg);
            if (matcher3.matches()) {
                double tx = Double.parseDouble(matcher3.group(1));
                double ty = Double.parseDouble(matcher3.group(2));
                double tz = Double.parseDouble(matcher3.group(3));
                _getCurrAgent().setRotTarget(tx, ty, tz);
            }
        } else if (slot.equals("RotNow")) {
            Matcher matcher3 = pattern3_.matcher(arg);
            if (matcher3.matches()) {
                double tx = Double.parseDouble(matcher3.group(1));
                double ty = Double.parseDouble(matcher3.group(2));
                double tz = Double.parseDouble(matcher3.group(3));
                _getCurrAgent().setRotNow(tx, ty, tz);
            }
        } else if (slot.equals("Background")) {
            Matcher matcher2 = pattern2_.matcher(arg);
            if (matcher2.matches()) {
                Agent ag = _getAgentByName(matcher2.group(1));
                ag.setBackground(matcher2.group(2));
            }
        } else if (slot.equals("HeadMoveRatio")) {
            Matcher matcher2 = pattern2_.matcher(arg);
            if (matcher2.matches()) {
                double d1 = Double.parseDouble(matcher2.group(1));
                double d2 = Double.parseDouble(matcher2.group(2));
                _getCurrAgent().setHeadMove(d1, d2);
            }
        } else if (slot.equals("Mask")) {
            if (arg.equals("DISABLE")) {
                _sendFadeOut();
            } else {
                if (! arg.equals(currAgent_)) {
                    _sendFadeOut();
                }
                currAgent_ = arg;
                _setupCurrMask();
                _sendFadeIn();
            }
        } else if (slot.equals("FaceMot")) {
            send("to @FSM set FaceMot = " + arg);

        } else if (slot.equals("Action")) {
            if (arg.equals("Thinking")) {
                _getCurrAgent().setRotTarget(+0.3, 0, 0);
                int v = random_.nextInt(8);
                switch(v) {
                case 0:
                    _getCurrAgent().setEyeRotNow(-5,  0, 0); // up
                    break;
                case 1:
                    _getCurrAgent().setEyeRotNow(+5,  0, 0); // down
                    break;
                case 2:
                    _getCurrAgent().setEyeRotNow( 0, -7, 0); // left
                    break;
                case 3:
                    _getCurrAgent().setEyeRotNow( 0, +7, 0); // right
                    break;
                case 4:
                    _getCurrAgent().setEyeRotNow(-4, -4, 0); //
                    break;
                case 5:
                    _getCurrAgent().setEyeRotNow(-4, +4, 0); //
                    break;
                case 6:
                    _getCurrAgent().setEyeRotNow(+4, -4, 0); //
                    break;
                case 7:
                    _getCurrAgent().setEyeRotNow(+4, +4, 0); //
                    break;
                }
            } else if (arg.equals("InfoRequest")) {
                _getCurrAgent().setRotTarget(0, 0, 0);
            } else if (arg.equals("Speaking")) {
                _getCurrAgent().setRotTarget(-0.5, 0, 0);
            } else if (arg.equals("Busy")) {
                _getCurrAgent().setRotTarget(5, 3, 0);
            } else if (arg.equals("Blink")) {
                send("to @FSM set FaceMot = BLINK 2");
            }
        } else if (slot.equals("Nod")) {
            double d = Double.parseDouble(arg);
            _getCurrAgent().startNodding(d);
        } else if (slot.equals("Refuse")) {
            double d = Double.parseDouble(arg);
            _getCurrAgent().startRefuse(d);
        } else if (slot.equals("Tilt")) {
            double d = Double.parseDouble(arg);
            _getCurrAgent().setHeadRotTarget(0, 0, d);
        } else if (slot.equals("Rot_kyt")) {
            Matcher matcher4 = pattern4_kyt.matcher(arg);
            if (matcher4.matches()) {
                double tx = Double.parseDouble(matcher4.group(1));
                double ty = Double.parseDouble(matcher4.group(2));
                double tz = Double.parseDouble(matcher4.group(3));
                int moveTime = Integer.parseInt(matcher4.group(4));
                _getCurrAgent().setRotTarget_kyt(tx, ty, tz, moveTime/faceUpdateCycle_);
            }
        }
    }
    
    private void _iteration2()
    {
        if (useAutoMove_) {
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - prevTime_;
            if (delta >= faceUpdateCycle_) {
                _getCurrAgent().calc();
                _outputFaceExp();
                _getCurrAgent().addClock((double)delta / 1000.0);
                prevTime_ = currentTime;
            }
        }
        if (isFsmAlive_ == false) {
            send("to @FSM inq Run");
            sleep(100);
        }
    }

    public void run()
    {
        prevTime_ = System.currentTimeMillis();
        send("rep Status.power = ON");
        while (true) {
            iteration();
            _iteration2();
        }
    }

    public static final String COPYRIGHT = 
        "(c)2003-2010 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)\n";
	
    public static void showVersion() {
        System.err.println("BehaviorManager");
        System.err.println(galatea.dialog.DialogStudioVersion.TSTAMP);
        System.err.print(COPYRIGHT);
        System.err.println();
    }
	
    /**
     * java -cp gdm.jar galatea.BehaviorManager
     *
     * [in]  From @DM set Mask = DISABLE
     * [out] to @FSM set AgentEnable = DISABLE
     *
     */
    public static void main(String argv[])
    {
    	String conf = "gdm.conf";
    	
    	Getopt g = new Getopt("", argv, "a:c:dev");
    	g.setOpterr(false);
    	int c;
    	while ((c = g.getopt()) != -1){
            switch (c)	{
            case 'a':
                // behaviorManager._setAgentByName(g.getOptarg());
                break;
            case 'c':
                conf = g.getOptarg();
                break;
            case 'd':
                // behaviorManager._setDebugMode(true);
                break;
            case 'e':
                // behaviorManager._setEventViewerMode(true);
                break;
            case 'v':
                showVersion();
                break;
            }
    	}

    	AgentUtil.loadConfigFile(conf);
    	BehaviorManager behaviorManager = new BehaviorManager();
    	behaviorManager.run();
    }

}
